/*
 * Decompiled with CFR 0.152.
 */
package swim.fabric;

import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.collections.HashTrieMap;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.fabric.FabricNode;
import swim.fabric.FabricPart;
import swim.fabric.FabricTier;
import swim.runtime.CellBinding;
import swim.runtime.CellContext;
import swim.runtime.HostBinding;
import swim.runtime.HostContext;
import swim.runtime.HostDef;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LogDef;
import swim.runtime.NodeBinding;
import swim.runtime.NodeDef;
import swim.runtime.PartBinding;
import swim.runtime.PolicyDef;
import swim.runtime.agent.AgentModel;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;

public class FabricHost
extends FabricTier
implements HostBinding,
HostContext {
    final HostBinding hostBinding;
    HostContext hostContext;
    HostDef hostDef;

    public FabricHost(HostBinding hostBinding, HostDef hostDef) {
        this.hostBinding = hostBinding;
        this.hostDef = hostDef;
    }

    public final HostDef hostDef() {
        return this.hostDef;
    }

    public final FabricPart fabricPart() {
        return (FabricPart)this.part().unwrapPart(FabricPart.class);
    }

    public final PartBinding part() {
        return this.hostContext.part();
    }

    public final HostBinding hostWrapper() {
        return this.hostBinding.hostWrapper();
    }

    public final HostBinding hostBinding() {
        return this.hostBinding;
    }

    public final HostContext hostContext() {
        return this.hostContext;
    }

    public void setHostContext(HostContext hostContext) {
        this.hostContext = hostContext;
        this.hostBinding.setHostContext((HostContext)this);
    }

    public <T> T unwrapHost(Class<T> hostClass) {
        if (hostClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return (T)this.hostContext.unwrapHost(hostClass);
    }

    @Override
    public final CellBinding cellBinding() {
        return this.hostBinding;
    }

    @Override
    public final CellContext cellContext() {
        return this.hostContext;
    }

    public Value partKey() {
        return this.hostContext.partKey();
    }

    public Uri hostUri() {
        return this.hostContext.hostUri();
    }

    public boolean isConnected() {
        return this.hostBinding.isConnected();
    }

    public boolean isRemote() {
        return this.hostBinding.isRemote();
    }

    public boolean isSecure() {
        return this.hostBinding.isSecure();
    }

    public boolean isPrimary() {
        return this.hostBinding.isPrimary();
    }

    public void setPrimary(boolean isPrimary) {
        this.hostBinding.setPrimary(isPrimary);
    }

    public boolean isReplica() {
        return this.hostBinding.isReplica();
    }

    public void setReplica(boolean isReplica) {
        this.hostBinding.setReplica(isReplica);
    }

    public boolean isMaster() {
        return this.hostBinding.isMaster();
    }

    public boolean isSlave() {
        return this.hostBinding.isSlave();
    }

    public void didBecomeMaster() {
        this.hostBinding.didBecomeMaster();
    }

    public void didBecomeSlave() {
        this.hostBinding.didBecomeSlave();
    }

    public HashTrieMap<Uri, NodeBinding> nodes() {
        return this.hostBinding.nodes();
    }

    public NodeBinding getNode(Uri nodeUri) {
        return this.hostBinding.getNode(nodeUri);
    }

    public NodeBinding openNode(Uri nodeUri) {
        return this.hostBinding.openNode(nodeUri);
    }

    public NodeBinding openNode(Uri nodeUri, NodeBinding node) {
        return this.hostBinding.openNode(nodeUri, node);
    }

    public Log createLog(LogDef logDef) {
        FabricPart part = this.fabricPart();
        return part != null ? part.createLog(logDef) : null;
    }

    public Log injectLog(Log log) {
        FabricPart part = this.fabricPart();
        return part != null ? part.injectLog(log) : log;
    }

    @Override
    protected Log openLog() {
        Log log = this.hostDef != null && this.hostDef.logDef() != null ? this.createLog(this.hostDef.logDef()) : this.openHostLog();
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        FabricPart part = this.fabricPart();
        return part != null ? part.createPolicy(policyDef) : null;
    }

    public Policy injectPolicy(Policy policy) {
        FabricPart part = this.fabricPart();
        return part != null ? part.injectPolicy(policy) : policy;
    }

    @Override
    protected Policy openPolicy() {
        Policy policy = this.hostDef != null && this.hostDef.policyDef() != null ? this.createPolicy(this.hostDef.policyDef()) : this.openHostPolicy();
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return policy;
    }

    public Stage createStage(StageDef stageDef) {
        FabricPart part = this.fabricPart();
        return part != null ? part.createStage(stageDef) : null;
    }

    public Stage injectStage(Stage stage) {
        FabricPart part = this.fabricPart();
        return part != null ? part.injectStage(stage) : stage;
    }

    @Override
    protected Stage openStage() {
        Stage stage = this.hostDef != null && this.hostDef.stageDef() != null ? this.createStage(this.hostDef.stageDef()) : this.openHostStage();
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        FabricPart part = this.fabricPart();
        return part != null ? part.createStore(storeDef) : null;
    }

    public StoreBinding injectStore(StoreBinding store) {
        FabricPart part = this.fabricPart();
        return part != null ? part.injectStore(store) : store;
    }

    @Override
    protected StoreBinding openStore() {
        StoreBinding store = null;
        store = this.hostDef != null && this.hostDef.storeDef() != null ? this.createStore(this.hostDef.storeDef()) : this.openHostStore();
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    protected Log openHostLog() {
        FabricPart part = this.fabricPart();
        return part != null ? part.openHostLog(this.hostUri()) : null;
    }

    protected Policy openHostPolicy() {
        FabricPart part = this.fabricPart();
        return part != null ? part.openHostPolicy(this.hostUri()) : null;
    }

    protected Stage openHostStage() {
        FabricPart part = this.fabricPart();
        return part != null ? part.openHostStage(this.hostUri()) : null;
    }

    protected StoreBinding openHostStore() {
        FabricPart part = this.fabricPart();
        return part != null ? part.openHostStore(this.hostUri()) : null;
    }

    public NodeDef getNodeDef(Uri nodeUri) {
        NodeDef nodeDef;
        HostDef hostDef = this.hostDef;
        NodeDef nodeDef2 = nodeDef = hostDef != null ? hostDef.getNodeDef(nodeUri) : null;
        if (nodeDef == null) {
            FabricPart part = this.fabricPart();
            nodeDef = part != null ? part.getNodeDef(this.hostUri(), nodeUri) : null;
        }
        return nodeDef;
    }

    public NodeBinding createNode(Uri nodeUri) {
        NodeBinding node = this.hostContext.createNode(nodeUri);
        if (node == null && !this.meshUri().isDefined()) {
            NodeDef nodeDef;
            HostDef hostDef = this.hostDef;
            NodeDef nodeDef2 = nodeDef = hostDef != null ? hostDef.getNodeDef(nodeUri) : null;
            if (nodeDef != null) {
                Value props = nodeDef.props(nodeUri);
                node = new AgentModel(props);
            }
        }
        return node;
    }

    public NodeBinding injectNode(Uri nodeUri, NodeBinding node) {
        NodeDef nodeDef = this.getNodeDef(nodeUri);
        return new FabricNode(this.hostContext.injectNode(nodeUri, node), nodeDef);
    }

    public Log openNodeLog(Uri nodeUri) {
        FabricPart part = this.fabricPart();
        return part != null ? part.openNodeLog(this.hostUri(), nodeUri) : null;
    }

    public Policy openNodePolicy(Uri nodeUri) {
        FabricPart part = this.fabricPart();
        return part != null ? part.openNodePolicy(this.hostUri(), nodeUri) : null;
    }

    public Stage openNodeStage(Uri nodeUri) {
        FabricPart part = this.fabricPart();
        return part != null ? part.openNodeStage(this.hostUri(), nodeUri) : null;
    }

    public StoreBinding openNodeStore(Uri nodeUri) {
        FabricPart part = this.fabricPart();
        return part != null ? part.openNodeStore(this.hostUri(), nodeUri) : null;
    }

    public LaneDef getLaneDef(Uri nodeUri, Uri laneUri) {
        LaneDef laneDef;
        HostDef hostDef = this.hostDef;
        LaneDef laneDef2 = laneDef = hostDef != null ? hostDef.getLaneDef(laneUri) : null;
        if (laneDef == null) {
            FabricPart part = this.fabricPart();
            laneDef = part != null ? part.getLaneDef(this.hostUri(), nodeUri, laneUri) : null;
        }
        return laneDef;
    }

    public LaneBinding createLane(Uri nodeUri, LaneDef laneDef) {
        return this.hostContext.createLane(nodeUri, laneDef);
    }

    public LaneBinding createLane(Uri nodeUri, Uri laneUri) {
        return this.hostContext.createLane(nodeUri, laneUri);
    }

    public LaneBinding injectLane(Uri nodeUri, Uri laneUri, LaneBinding lane) {
        return this.hostContext.injectLane(nodeUri, laneUri, lane);
    }

    public void openLanes(Uri nodeUri, NodeBinding node) {
        this.hostContext.openLanes(nodeUri, node);
    }

    public Log openLaneLog(Uri nodeUri, Uri laneUri) {
        FabricPart part = this.fabricPart();
        return part != null ? part.openLaneLog(this.hostUri(), nodeUri, laneUri) : null;
    }

    public Policy openLanePolicy(Uri nodeUri, Uri laneUri) {
        FabricPart part = this.fabricPart();
        return part != null ? part.openLanePolicy(this.hostUri(), nodeUri, laneUri) : null;
    }

    public Stage openLaneStage(Uri nodeUri, Uri laneUri) {
        FabricPart part = this.fabricPart();
        return part != null ? part.openLaneStage(this.hostUri(), nodeUri, laneUri) : null;
    }

    public StoreBinding openLaneStore(Uri nodeUri, Uri laneUri) {
        FabricPart part = this.fabricPart();
        return part != null ? part.openLaneStore(this.hostUri(), nodeUri, laneUri) : null;
    }

    public AgentFactory<?> createAgentFactory(Uri nodeUri, AgentDef agentDef) {
        return this.hostContext.createAgentFactory(nodeUri, agentDef);
    }

    public <A extends Agent> AgentFactory<A> createAgentFactory(Uri nodeUri, Class<? extends A> agentClass) {
        return this.hostContext.createAgentFactory(nodeUri, agentClass);
    }

    public void openAgents(Uri nodeUri, NodeBinding node) {
        this.hostContext.openAgents(nodeUri, node);
        if (!this.meshUri().isDefined()) {
            NodeDef nodeDef;
            HostDef hostDef = this.hostDef;
            NodeDef nodeDef2 = nodeDef = hostDef != null ? hostDef.getNodeDef(nodeUri) : null;
            if (nodeDef != null && node instanceof AgentModel) {
                AgentModel agentModel = (AgentModel)node;
                for (AgentDef agentDef : nodeDef.agentDefs()) {
                    AgentFactory<?> agentFactory = this.createAgentFactory(nodeUri, agentDef);
                    if (agentDef == null) continue;
                    Value props = agentDef.props();
                    if (!props.isDefined()) {
                        props = agentModel.props();
                    }
                    agentModel.addAgentView(agentModel.createAgent(agentFactory, props));
                }
            }
        }
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        return this.hostContext.authenticate(credentials);
    }

    public void didConnect() {
        this.hostContext.didConnect();
    }

    public void didDisconnect() {
        this.hostContext.didDisconnect();
    }

    public void didClose() {
        this.hostBinding.didClose();
    }

    public void didFail(Throwable error) {
        this.hostBinding.didFail(error);
    }
}

