/*
 * Decompiled with CFR 0.152.
 */
package swim.fabric;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.agent.AgentDef;
import swim.api.auth.Authenticator;
import swim.api.auth.AuthenticatorDef;
import swim.api.plane.PlaneDef;
import swim.api.plane.PlaneException;
import swim.api.plane.PlaneFactory;
import swim.api.space.Space;
import swim.api.space.SpaceDef;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.concurrent.StageDef;
import swim.fabric.Fabric;
import swim.fabric.FabricDef;
import swim.fabric.FabricHostDef;
import swim.fabric.FabricLaneDef;
import swim.fabric.FabricMeshDef;
import swim.fabric.FabricNodeDef;
import swim.fabric.FabricPartDef;
import swim.kernel.KernelContext;
import swim.kernel.KernelProxy;
import swim.runtime.HostDef;
import swim.runtime.LaneDef;
import swim.runtime.LogDef;
import swim.runtime.MeshDef;
import swim.runtime.NodeDef;
import swim.runtime.PartDef;
import swim.runtime.PartPredicate;
import swim.runtime.PolicyDef;
import swim.store.StoreDef;
import swim.structure.Item;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriMapper;
import swim.uri.UriPattern;

public class FabricKernel
extends KernelProxy {
    final double kernelPriority;
    volatile HashTrieMap<String, Fabric> fabrics;
    private static final double KERNEL_PRIORITY = 1.0;
    static final AtomicReferenceFieldUpdater<FabricKernel, HashTrieMap<String, Fabric>> FABRICS = AtomicReferenceFieldUpdater.newUpdater(FabricKernel.class, HashTrieMap.class, "fabrics");

    public FabricKernel(double kernelPriority) {
        this.kernelPriority = kernelPriority;
        this.fabrics = HashTrieMap.empty();
    }

    public FabricKernel() {
        this(1.0);
    }

    public final double kernelPriority() {
        return this.kernelPriority;
    }

    public SpaceDef defineSpace(Item spaceConfig) {
        FabricDef fabricDef = this.defineFabricSpace(spaceConfig);
        return fabricDef != null ? fabricDef : super.defineSpace(spaceConfig);
    }

    public FabricDef defineFabricSpace(Item spaceConfig) {
        String fabricProvider;
        Value value = spaceConfig.toValue();
        Value header = value.getAttr("fabric");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || FabricKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            String spaceName = spaceConfig.key().stringValue(null);
            FingerTrieSeq planeDefs = FingerTrieSeq.empty();
            HashTrieMap authenticatorDefs = HashTrieMap.empty();
            HashTrieMap meshDefs = HashTrieMap.empty();
            HashTrieMap partDefs = HashTrieMap.empty();
            UriMapper hostDefs = UriMapper.empty();
            UriMapper nodeDefs = UriMapper.empty();
            UriMapper laneDefs = UriMapper.empty();
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                PlaneDef planeDef = kernel.definePlane(item);
                if (planeDef != null) {
                    planeDefs = planeDefs.appended((Object)planeDef);
                    continue;
                }
                AuthenticatorDef authenticatorDef = kernel.defineAuthenticator(item);
                if (authenticatorDef != null) {
                    authenticatorDefs = authenticatorDefs.updated((Object)authenticatorDef.authenticatorName(), (Object)authenticatorDef);
                    continue;
                }
                MeshDef meshDef = kernel.defineMesh(item);
                if (meshDef != null) {
                    meshDefs = meshDefs.updated((Object)meshDef.meshUri(), (Object)meshDef);
                    continue;
                }
                PartDef partDef = kernel.definePart(item);
                if (partDef != null) {
                    partDefs = partDefs.updated((Object)partDef.partKey(), (Object)partDef);
                    continue;
                }
                HostDef hostDef = kernel.defineHost(item);
                if (hostDef != null) {
                    hostDefs = hostDefs.updated(hostDef.hostPattern(), (Object)hostDef);
                    continue;
                }
                NodeDef nodeDef = kernel.defineNode(item);
                if (nodeDef != null) {
                    nodeDefs = nodeDefs.updated(nodeDef.nodePattern(), (Object)nodeDef);
                    continue;
                }
                LaneDef laneDef = kernel.defineLane(item);
                if (laneDef != null) {
                    laneDefs = laneDefs.updated(laneDef.lanePattern(), (Object)laneDef);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            return new FabricDef(spaceName, (FingerTrieSeq<PlaneDef>)planeDefs, (HashTrieMap<String, AuthenticatorDef>)authenticatorDefs, (HashTrieMap<Uri, MeshDef>)meshDefs, (HashTrieMap<Value, PartDef>)partDefs, (UriMapper<HostDef>)hostDefs, (UriMapper<NodeDef>)nodeDefs, (UriMapper<LaneDef>)laneDefs, logDef, policyDef, stageDef, storeDef);
        }
        return null;
    }

    public Space openSpace(SpaceDef spaceDef) {
        if (spaceDef instanceof FabricDef) {
            return this.openFabric((FabricDef)spaceDef);
        }
        return super.openSpace(spaceDef);
    }

    public Fabric openFabric(FabricDef fabricDef) {
        Fabric fabric;
        block2: {
            HashTrieMap<String, Fabric> oldFabrics;
            Fabric oldFabric;
            String spaceName = fabricDef.spaceName;
            fabric = null;
            while ((oldFabric = (Fabric)((Object)(oldFabrics = this.fabrics).get((Object)spaceName))) == null) {
                HashTrieMap newFabrics;
                if (fabric == null) {
                    fabric = this.createFabric(spaceName, fabricDef);
                }
                if (!FABRICS.compareAndSet(this, oldFabrics, (HashTrieMap<String, Fabric>)(newFabrics = oldFabrics.updated((Object)spaceName, (Object)fabric)))) continue;
                if (!this.isStarted()) break block2;
                fabric.start();
                break block2;
            }
            fabric = oldFabric;
        }
        return fabric;
    }

    protected Fabric createFabric(String spaceName, FabricDef spaceDef) {
        KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
        Fabric fabric = new Fabric(spaceName, spaceDef, kernel);
        this.createAuthenticators(fabric, spaceDef);
        this.createPlanes(fabric, spaceDef);
        return fabric;
    }

    protected void createAuthenticators(Fabric fabric, FabricDef spaceDef) {
        for (AuthenticatorDef authenticatorDef : spaceDef.authenticatorDefs()) {
            if (fabric.getAuthenticator(authenticatorDef.authenticatorName()) != null) continue;
            this.createAuthenticator(fabric, authenticatorDef);
        }
    }

    protected void createAuthenticator(Fabric fabric, AuthenticatorDef authenticatorDef) {
        KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
        Authenticator authenticator = kernel.createAuthenticator(authenticatorDef, null);
        if (authenticator != null) {
            authenticator = kernel.injectAuthenticator(authenticator);
        }
        if (authenticator != null) {
            fabric.addAuthenticator(authenticatorDef.authenticatorName(), authenticator);
        }
    }

    protected void createPlanes(Fabric fabric, FabricDef spaceDef) {
        for (PlaneDef planeDef : spaceDef.planeDefs()) {
            if (fabric.getPlane(planeDef.planeName()) != null) continue;
            this.createPlane(fabric, planeDef);
        }
    }

    protected void createPlane(Fabric fabric, PlaneDef planeDef) {
        KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
        PlaneFactory planeFactory = kernel.createPlaneFactory(planeDef, null);
        if (planeFactory == null) {
            throw new PlaneException("No factory for plane: " + planeDef.planeName());
        }
        fabric.openPlane(planeDef.planeName(), planeFactory);
    }

    public Space getSpace(String spaceName) {
        Fabric space = this.getFabric(spaceName);
        if (space == null) {
            space = super.getSpace(spaceName);
        }
        return space;
    }

    public Fabric getFabric(String spaceName) {
        return (Fabric)((Object)this.fabrics.get((Object)spaceName));
    }

    public MeshDef defineMesh(Item meshConfig) {
        FabricMeshDef meshDef = this.defineFabricMesh(meshConfig);
        return meshDef != null ? meshDef : super.defineMesh(meshConfig);
    }

    public FabricMeshDef defineFabricMesh(Item meshConfig) {
        String fabricProvider;
        Value value = meshConfig.toValue();
        Value header = value.getAttr("mesh");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || FabricKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            Uri meshUri = Uri.empty();
            HashTrieMap partDefs = HashTrieMap.empty();
            UriMapper hostDefs = UriMapper.empty();
            UriMapper nodeDefs = UriMapper.empty();
            UriMapper laneDefs = UriMapper.empty();
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                if (item.keyEquals((Object)"uri")) {
                    meshUri = (Uri)item.toValue().cast(Uri.form(), (Object)meshUri);
                    continue;
                }
                PartDef partDef = kernel.definePart(item);
                if (partDef != null) {
                    partDefs = partDefs.updated((Object)partDef.partKey(), (Object)partDef);
                    continue;
                }
                HostDef hostDef = kernel.defineHost(item);
                if (hostDef != null) {
                    hostDefs = hostDefs.updated(hostDef.hostPattern(), (Object)hostDef);
                    continue;
                }
                NodeDef nodeDef = kernel.defineNode(item);
                if (nodeDef != null) {
                    nodeDefs = nodeDefs.updated(nodeDef.nodePattern(), (Object)nodeDef);
                    continue;
                }
                LaneDef laneDef = kernel.defineLane(item);
                if (laneDef != null) {
                    laneDefs = laneDefs.updated(laneDef.lanePattern(), (Object)laneDef);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            return new FabricMeshDef(meshUri, (HashTrieMap<Value, PartDef>)partDefs, (UriMapper<HostDef>)hostDefs, (UriMapper<NodeDef>)nodeDefs, (UriMapper<LaneDef>)laneDefs, logDef, policyDef, stageDef, storeDef);
        }
        return null;
    }

    public PartDef definePart(Item partConfig) {
        FabricPartDef partDef = this.defineFabricPart(partConfig);
        return partDef != null ? partDef : super.definePart(partConfig);
    }

    public FabricPartDef defineFabricPart(Item partConfig) {
        String fabricProvider;
        Value value = partConfig.toValue();
        Value header = value.getAttr("part");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || FabricKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            Value partKey = null;
            PartPredicate predicate = null;
            boolean isGateway = false;
            UriMapper hostDefs = UriMapper.empty();
            UriMapper nodeDefs = UriMapper.empty();
            UriMapper laneDefs = UriMapper.empty();
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                if (item.keyEquals((Object)"key")) {
                    partKey = item.toValue();
                    continue;
                }
                if (item.keyEquals((Object)"predicate")) {
                    predicate = PartPredicate.fromValue((Value)item.toValue());
                    continue;
                }
                if (item.keyEquals((Object)"isGateway")) {
                    isGateway = item.toValue().booleanValue(isGateway);
                    continue;
                }
                HostDef hostDef = kernel.defineHost(item);
                if (hostDef != null) {
                    hostDefs = hostDefs.updated(hostDef.hostPattern(), (Object)hostDef);
                    continue;
                }
                NodeDef nodeDef = kernel.defineNode(item);
                if (nodeDef != null) {
                    nodeDefs = nodeDefs.updated(nodeDef.nodePattern(), (Object)nodeDef);
                    continue;
                }
                LaneDef laneDef = kernel.defineLane(item);
                if (laneDef != null) {
                    laneDefs = laneDefs.updated(laneDef.lanePattern(), (Object)laneDef);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            if (partKey != null && predicate != null) {
                return new FabricPartDef(partKey, predicate, isGateway, (UriMapper<HostDef>)hostDefs, (UriMapper<NodeDef>)nodeDefs, (UriMapper<LaneDef>)laneDefs, logDef, policyDef, stageDef, storeDef);
            }
        }
        return null;
    }

    public HostDef defineHost(Item hostConfig) {
        FabricHostDef hostDef = this.defineFabricHost(hostConfig);
        return hostDef != null ? hostDef : super.defineHost(hostConfig);
    }

    public FabricHostDef defineFabricHost(Item hostConfig) {
        String fabricProvider;
        Value value = hostConfig.toValue();
        Value header = value.getAttr("host");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || FabricKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            UriPattern hostPattern = UriPattern.empty();
            boolean isPrimary = false;
            boolean isReplica = false;
            UriMapper nodeDefs = UriMapper.empty();
            UriMapper laneDefs = UriMapper.empty();
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                if (item.keyEquals((Object)"uri") || item.keyEquals((Object)"pattern")) {
                    hostPattern = (UriPattern)item.toValue().cast(UriPattern.form(), (Object)hostPattern);
                    continue;
                }
                if (item.keyEquals((Object)"primary") || item.keyEquals((Object)"isPrimary")) {
                    isPrimary = item.toValue().booleanValue(isPrimary);
                    continue;
                }
                if (item.keyEquals((Object)"replica") || item.keyEquals((Object)"isReplica")) {
                    isReplica = item.toValue().booleanValue(isReplica);
                    continue;
                }
                NodeDef nodeDef = kernel.defineNode(item);
                if (nodeDef != null) {
                    nodeDefs = nodeDefs.updated(nodeDef.nodePattern(), (Object)nodeDef);
                    continue;
                }
                LaneDef laneDef = kernel.defineLane(item);
                if (laneDef != null) {
                    laneDefs = laneDefs.updated(laneDef.lanePattern(), (Object)laneDef);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            return new FabricHostDef(hostPattern, isPrimary, isReplica, (UriMapper<NodeDef>)nodeDefs, (UriMapper<LaneDef>)laneDefs, logDef, policyDef, stageDef, storeDef);
        }
        return null;
    }

    public NodeDef defineNode(Item nodeConfig) {
        FabricNodeDef nodeDef = this.defineFabricNode(nodeConfig);
        return nodeDef != null ? nodeDef : super.defineNode(nodeConfig);
    }

    public FabricNodeDef defineFabricNode(Item nodeConfig) {
        String fabricProvider;
        Value value = nodeConfig.toValue();
        Value header = value.getAttr("node");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || FabricKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            UriPattern nodePattern = null;
            FingerTrieSeq agentDefs = FingerTrieSeq.empty();
            UriMapper laneDefs = UriMapper.empty();
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                if (item.keyEquals((Object)"uri") || item.keyEquals((Object)"pattern")) {
                    nodePattern = (UriPattern)item.toValue().cast(UriPattern.form(), nodePattern);
                    continue;
                }
                AgentDef agentDef = kernel.defineAgent(item);
                if (agentDef != null) {
                    agentDefs = agentDefs.appended((Object)agentDef);
                    continue;
                }
                LaneDef laneDef = kernel.defineLane(item);
                if (laneDef != null) {
                    laneDefs = laneDefs.updated(laneDef.lanePattern(), (Object)laneDef);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            if (nodePattern != null) {
                return new FabricNodeDef(nodePattern, (FingerTrieSeq<AgentDef>)agentDefs, (UriMapper<LaneDef>)laneDefs, logDef, policyDef, stageDef, storeDef);
            }
        }
        return null;
    }

    public LaneDef defineLane(Item laneConfig) {
        FabricLaneDef laneDef = this.defineFabricLane(laneConfig);
        return laneDef != null ? laneDef : super.defineLane(laneConfig);
    }

    public FabricLaneDef defineFabricLane(Item laneConfig) {
        String fabricProvider;
        Value value = laneConfig.toValue();
        Value header = value.getAttr("lane");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || FabricKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            String laneType = header.get("type").stringValue(null);
            UriPattern lanePattern = null;
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                if (item.keyEquals((Object)"uri") || item.keyEquals((Object)"pattern")) {
                    lanePattern = (UriPattern)item.toValue().cast(UriPattern.form(), lanePattern);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            if (lanePattern != null) {
                return new FabricLaneDef(lanePattern, laneType, logDef, policyDef, stageDef, storeDef);
            }
        }
        return null;
    }

    public void didStart() {
        for (Fabric fabric : this.fabrics.values()) {
            fabric.start();
        }
    }

    public void willStop() {
        for (Fabric fabric : this.fabrics.values()) {
            fabric.stop();
        }
    }

    public static FabricKernel fromValue(Value moduleConfig) {
        Value header = moduleConfig.getAttr("kernel");
        String kernelClassName = header.get("class").stringValue(null);
        if (kernelClassName == null || FabricKernel.class.getName().equals(kernelClassName)) {
            double kernelPriority = header.get("priority").doubleValue(1.0);
            return new FabricKernel(kernelPriority);
        }
        return null;
    }
}

