/*
 * Decompiled with CFR 0.152.
 */
package swim.fabric;

import swim.api.Lane;
import swim.api.agent.AgentContext;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.fabric.FabricNode;
import swim.fabric.FabricTier;
import swim.runtime.CellBinding;
import swim.runtime.CellContext;
import swim.runtime.LaneBinding;
import swim.runtime.LaneContext;
import swim.runtime.LaneDef;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.runtime.LogDef;
import swim.runtime.NodeBinding;
import swim.runtime.PolicyDef;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;
import swim.warp.CommandMessage;

public class FabricLane
extends FabricTier
implements LaneBinding,
LaneContext {
    final LaneBinding laneBinding;
    LaneContext laneContext;
    LaneDef laneDef;

    public FabricLane(LaneBinding laneBinding, LaneDef laneDef) {
        this.laneBinding = laneBinding;
        this.laneDef = laneDef;
    }

    public final LaneDef laneDef() {
        return this.laneDef;
    }

    public final FabricNode fabricNode() {
        return (FabricNode)this.node().unwrapNode(FabricNode.class);
    }

    public final NodeBinding node() {
        return this.laneContext.node();
    }

    public final LaneBinding laneWrapper() {
        return this.laneBinding.laneWrapper();
    }

    public final LaneBinding laneBinding() {
        return this.laneBinding;
    }

    public final LaneContext laneContext() {
        return this.laneContext;
    }

    public void setLaneContext(LaneContext laneContext) {
        this.laneContext = laneContext;
        this.laneBinding.setLaneContext((LaneContext)this);
    }

    public <T> T unwrapLane(Class<T> laneClass) {
        if (laneClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return (T)this.laneContext.unwrapLane(laneClass);
    }

    @Override
    public final CellBinding cellBinding() {
        return this.laneBinding;
    }

    @Override
    public final CellContext cellContext() {
        return this.laneContext;
    }

    public Value partKey() {
        return this.laneContext.partKey();
    }

    public Uri hostUri() {
        return this.laneContext.hostUri();
    }

    public Uri nodeUri() {
        return this.laneContext.nodeUri();
    }

    public Uri laneUri() {
        return this.laneContext.laneUri();
    }

    public String laneType() {
        return this.laneBinding.laneType();
    }

    public Identity identity() {
        return this.laneContext.identity();
    }

    public Lane getLaneView(AgentContext agentContext) {
        return this.laneBinding.getLaneView(agentContext);
    }

    public void openLaneView(Lane lane) {
        this.laneBinding.openLaneView(lane);
    }

    public void closeLaneView(Lane lane) {
        this.laneBinding.closeLaneView(lane);
    }

    public FingerTrieSeq<LinkContext> uplinks() {
        return this.laneBinding.uplinks();
    }

    public LinkBinding getUplink(Value linkKey) {
        return this.laneBinding.getUplink(linkKey);
    }

    public void closeUplink(Value linkKey) {
        this.laneBinding.closeUplink(linkKey);
    }

    public void pushUpCommand(CommandMessage message) {
        this.laneBinding.pushUpCommand(message);
    }

    public Log createLog(LogDef logDef) {
        FabricNode node = this.fabricNode();
        return node != null ? node.createLog(logDef) : null;
    }

    public Log injectLog(Log log) {
        FabricNode node = this.fabricNode();
        return node != null ? node.injectLog(log) : log;
    }

    @Override
    protected Log openLog() {
        Log log = this.laneDef != null && this.laneDef.logDef() != null ? this.createLog(this.laneDef.logDef()) : this.openLaneLog();
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        FabricNode node = this.fabricNode();
        return node != null ? node.createPolicy(policyDef) : null;
    }

    public Policy injectPolicy(Policy policy) {
        FabricNode node = this.fabricNode();
        return node != null ? node.injectPolicy(policy) : policy;
    }

    @Override
    protected Policy openPolicy() {
        Policy policy = this.laneDef != null && this.laneDef.policyDef() != null ? this.createPolicy(this.laneDef.policyDef()) : this.openLanePolicy();
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return policy;
    }

    public Stage createStage(StageDef stageDef) {
        FabricNode node = this.fabricNode();
        return node != null ? node.createStage(stageDef) : null;
    }

    public Stage injectStage(Stage stage) {
        FabricNode node = this.fabricNode();
        return node != null ? node.injectStage(stage) : stage;
    }

    @Override
    protected Stage openStage() {
        Stage stage = this.laneDef != null && this.laneDef.stageDef() != null ? this.createStage(this.laneDef.stageDef()) : this.openLaneStage();
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        FabricNode node = this.fabricNode();
        return node != null ? node.createStore(storeDef) : null;
    }

    public StoreBinding injectStore(StoreBinding store) {
        FabricNode node = this.fabricNode();
        return node != null ? node.injectStore(store) : store;
    }

    @Override
    protected StoreBinding openStore() {
        StoreBinding store = null;
        store = this.laneDef != null && this.laneDef.storeDef() != null ? this.createStore(this.laneDef.storeDef()) : this.openLaneStore();
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    protected Log openLaneLog() {
        FabricNode node = this.fabricNode();
        return node != null ? node.openLaneLog(this.laneUri()) : null;
    }

    protected Policy openLanePolicy() {
        FabricNode node = this.fabricNode();
        return node != null ? node.openLanePolicy(this.laneUri()) : null;
    }

    protected Stage openLaneStage() {
        FabricNode node = this.fabricNode();
        return node != null ? node.openLaneStage(this.laneUri()) : null;
    }

    protected StoreBinding openLaneStore() {
        FabricNode node = this.fabricNode();
        return node != null ? node.openLaneStore(this.laneUri()) : null;
    }

    public void didClose() {
        this.laneBinding.didClose();
    }

    public void didFail(Throwable error) {
        this.laneBinding.didFail(error);
    }
}

