/*
 * Decompiled with CFR 0.152.
 */
package swim.fabric;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.concurrent.StageDef;
import swim.runtime.LaneDef;
import swim.runtime.LogDef;
import swim.runtime.PolicyDef;
import swim.store.StoreDef;
import swim.uri.Uri;
import swim.uri.UriPattern;
import swim.util.Murmur3;

public class FabricLaneDef
implements LaneDef,
Debug {
    final UriPattern lanePattern;
    final String laneType;
    final LogDef logDef;
    final PolicyDef policyDef;
    final StageDef stageDef;
    final StoreDef storeDef;
    private static int hashSeed;

    public FabricLaneDef(UriPattern lanePattern, String laneType, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        this.lanePattern = lanePattern;
        this.laneType = laneType;
        this.logDef = logDef;
        this.policyDef = policyDef;
        this.stageDef = stageDef;
        this.storeDef = storeDef;
    }

    public final Uri laneUri() {
        return this.lanePattern.isUri() ? this.lanePattern.toUri() : null;
    }

    public final UriPattern lanePattern() {
        return this.lanePattern;
    }

    public FabricLaneDef lanePattern(UriPattern lanePattern) {
        return this.copy(lanePattern, this.laneType, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final String laneType() {
        return this.laneType;
    }

    public FabricLaneDef laneType(String laneType) {
        return this.copy(this.lanePattern, laneType, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final LogDef logDef() {
        return this.logDef;
    }

    public FabricLaneDef logDef(LogDef logDef) {
        return this.copy(this.lanePattern, this.laneType, logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final PolicyDef policyDef() {
        return this.policyDef;
    }

    public FabricLaneDef policyDef(PolicyDef policyDef) {
        return this.copy(this.lanePattern, this.laneType, this.logDef, policyDef, this.stageDef, this.storeDef);
    }

    public final StageDef stageDef() {
        return this.stageDef;
    }

    public FabricLaneDef stageDef(StageDef stageDef) {
        return this.copy(this.lanePattern, this.laneType, this.logDef, this.policyDef, stageDef, this.storeDef);
    }

    public final StoreDef storeDef() {
        return this.storeDef;
    }

    public FabricLaneDef storeDef(StoreDef storeDef) {
        return this.copy(this.lanePattern, this.laneType, this.logDef, this.policyDef, this.stageDef, storeDef);
    }

    protected FabricLaneDef copy(UriPattern lanePattern, String laneType, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        return new FabricLaneDef(lanePattern, laneType, logDef, policyDef, stageDef, storeDef);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FabricLaneDef) {
            FabricLaneDef that = (FabricLaneDef)other;
            return this.lanePattern.equals((Object)that.lanePattern) && (this.laneType == null ? that.laneType == null : this.laneType.equals(that.laneType)) && (this.logDef == null ? that.logDef == null : this.logDef.equals(that.logDef)) && (this.policyDef == null ? that.policyDef == null : this.policyDef.equals(that.policyDef)) && (this.stageDef == null ? that.stageDef == null : this.stageDef.equals(that.stageDef)) && (this.storeDef == null ? that.storeDef == null : this.storeDef.equals(that.storeDef));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(FabricLaneDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.lanePattern.hashCode()), (int)Murmur3.hash((Object)this.laneType)), (int)Murmur3.hash((Object)this.logDef)), (int)Murmur3.hash((Object)this.policyDef)), (int)Murmur3.hash((Object)this.stageDef)), (int)Murmur3.hash((Object)this.storeDef)));
    }

    public void debug(Output<?> output) {
        output = output.write("FabricLaneDef").write(46);
        output = this.lanePattern.isUri() ? output.write("fromLaneUri").write(40).debug((Object)this.lanePattern.toUri()).write(41) : output.write("fromLanePattern").write(40).debug((Object)this.lanePattern).write(41);
        if (this.laneType != null) {
            output = output.write(46).write("laneType").write(40).debug((Object)this.laneType).write(41);
        }
        if (this.logDef != null) {
            output = output.write(46).write("logDef").write(40).debug((Object)this.logDef).write(41);
        }
        if (this.policyDef != null) {
            output = output.write(46).write("policyDef").write(40).debug((Object)this.policyDef).write(41);
        }
        if (this.stageDef != null) {
            output = output.write(46).write("stageDef").write(40).debug((Object)this.stageDef).write(41);
        }
        if (this.storeDef != null) {
            output = output.write(46).write("storeDef").write(40).debug((Object)this.storeDef).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static FabricLaneDef fromLaneUri(Uri laneUri) {
        return new FabricLaneDef(UriPattern.from((Uri)laneUri), null, null, null, null, null);
    }

    public static FabricLaneDef fromLaneUri(String laneUri) {
        return FabricLaneDef.fromLaneUri(Uri.parse((String)laneUri));
    }

    public static FabricLaneDef fromLanePattern(UriPattern lanePattern) {
        return new FabricLaneDef(lanePattern, null, null, null, null, null);
    }

    public static FabricLaneDef fromLanePattern(String lanePattern) {
        return FabricLaneDef.fromLanePattern(UriPattern.parse((String)lanePattern));
    }
}

