/*
 * Decompiled with CFR 0.152.
 */
package swim.fabric;

import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.fabric.Fabric;
import swim.fabric.FabricPart;
import swim.fabric.FabricTier;
import swim.runtime.CellBinding;
import swim.runtime.CellContext;
import swim.runtime.EdgeBinding;
import swim.runtime.HostBinding;
import swim.runtime.HostDef;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LogDef;
import swim.runtime.MeshBinding;
import swim.runtime.MeshContext;
import swim.runtime.MeshDef;
import swim.runtime.NodeBinding;
import swim.runtime.NodeDef;
import swim.runtime.PartBinding;
import swim.runtime.PartDef;
import swim.runtime.PolicyDef;
import swim.runtime.agent.AgentModel;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;

public class FabricMesh
extends FabricTier
implements MeshBinding,
MeshContext {
    final MeshBinding meshBinding;
    MeshContext meshContext;
    MeshDef meshDef;

    public FabricMesh(MeshBinding meshBinding, MeshDef meshDef) {
        this.meshBinding = meshBinding;
        this.meshDef = meshDef;
    }

    public final MeshDef meshDef() {
        return this.meshDef;
    }

    public final Fabric fabricEdge() {
        return (Fabric)((Object)this.edge().unwrapEdge(Fabric.class));
    }

    public final EdgeBinding edge() {
        return this.meshContext.edge();
    }

    public final MeshBinding meshWrapper() {
        return this.meshBinding.meshWrapper();
    }

    public final MeshBinding meshBinding() {
        return this.meshBinding;
    }

    public final MeshContext meshContext() {
        return this.meshContext;
    }

    public void setMeshContext(MeshContext meshContext) {
        this.meshContext = meshContext;
        this.meshBinding.setMeshContext((MeshContext)this);
    }

    public <T> T unwrapMesh(Class<T> meshClass) {
        if (meshClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return (T)this.meshContext.unwrapMesh(meshClass);
    }

    @Override
    public final CellBinding cellBinding() {
        return this.meshBinding;
    }

    @Override
    public final CellContext cellContext() {
        return this.meshContext;
    }

    public PartBinding gateway() {
        return this.meshBinding.gateway();
    }

    public void setGateway(PartBinding gateway) {
        this.meshBinding.setGateway(gateway);
    }

    public PartBinding ourself() {
        return this.meshBinding.ourself();
    }

    public void setOurself(PartBinding ourself) {
        this.meshBinding.setOurself(ourself);
    }

    public FingerTrieSeq<PartBinding> parts() {
        return this.meshBinding.parts();
    }

    public PartBinding getPart(Uri nodeUri) {
        return this.meshBinding.getPart(nodeUri);
    }

    public PartBinding getPart(Value partKey) {
        return this.meshBinding.getPart(partKey);
    }

    public PartBinding openPart(Uri nodeUri) {
        return this.meshBinding.openPart(nodeUri);
    }

    public PartBinding openGateway() {
        return this.meshBinding.openGateway();
    }

    public PartBinding addPart(Value partKey, PartBinding part) {
        return this.meshBinding.addPart(partKey, part);
    }

    public Log createLog(LogDef logDef) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.createLog(logDef) : null;
    }

    public Log injectLog(Log log) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.injectLog(log) : log;
    }

    @Override
    protected Log openLog() {
        Log log = this.meshDef != null && this.meshDef.logDef() != null ? this.createLog(this.meshDef.logDef()) : this.openMeshLog();
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.createPolicy(policyDef) : null;
    }

    public Policy injectPolicy(Policy policy) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.injectPolicy(policy) : policy;
    }

    @Override
    protected Policy openPolicy() {
        Policy policy = this.meshDef != null && this.meshDef.policyDef() != null ? this.createPolicy(this.meshDef.policyDef()) : this.openMeshPolicy();
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return policy;
    }

    public Stage createStage(StageDef stageDef) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.createStage(stageDef) : null;
    }

    public Stage injectStage(Stage stage) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.injectStage(stage) : stage;
    }

    @Override
    protected Stage openStage() {
        Stage stage = this.meshDef != null && this.meshDef.stageDef() != null ? this.createStage(this.meshDef.stageDef()) : this.openMeshStage();
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.createStore(storeDef) : null;
    }

    public StoreBinding injectStore(StoreBinding store) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.injectStore(store) : store;
    }

    @Override
    protected StoreBinding openStore() {
        StoreBinding store = null;
        store = this.meshDef != null && this.meshDef.storeDef() != null ? this.createStore(this.meshDef.storeDef()) : this.openMeshStore();
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    protected Log openMeshLog() {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openMeshLog(this.meshUri()) : null;
    }

    protected Policy openMeshPolicy() {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openMeshPolicy(this.meshUri()) : null;
    }

    protected Stage openMeshStage() {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openMeshStage(this.meshUri()) : null;
    }

    protected StoreBinding openMeshStore() {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openMeshStore(this.meshUri()) : null;
    }

    public PartDef getPartDef(Value partKey) {
        PartDef partDef;
        MeshDef meshDef = this.meshDef;
        PartDef partDef2 = partDef = meshDef != null ? meshDef.getPartDef(partKey) : null;
        if (partDef == null) {
            Fabric edge = this.fabricEdge();
            partDef = edge != null ? edge.getPartDef(this.meshUri(), partKey) : null;
        }
        return partDef;
    }

    public PartBinding createPart(Value partKey) {
        return this.meshContext.createPart(partKey);
    }

    public PartBinding injectPart(Value partKey, PartBinding part) {
        PartDef partDef = this.getPartDef(partKey);
        return new FabricPart(this.meshContext.injectPart(partKey, part), partDef);
    }

    public Log openPartLog(Value partKey) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openPartLog(this.meshUri(), partKey) : null;
    }

    public Policy openPartPolicy(Value partKey) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openPartPolicy(this.meshUri(), partKey) : null;
    }

    public Stage openPartStage(Value partKey) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openPartStage(this.meshUri(), partKey) : null;
    }

    public StoreBinding openPartStore(Value partKey) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openPartStore(this.meshUri(), partKey) : null;
    }

    public HostDef getHostDef(Value partKey, Uri hostUri) {
        HostDef hostDef;
        MeshDef meshDef = this.meshDef;
        HostDef hostDef2 = hostDef = meshDef != null ? meshDef.getHostDef(hostUri) : null;
        if (hostDef == null) {
            Fabric edge = this.fabricEdge();
            hostDef = edge != null ? edge.getHostDef(this.meshUri(), partKey, hostUri) : null;
        }
        return hostDef;
    }

    public HostBinding createHost(Value partKey, Uri hostUri) {
        return this.meshContext.createHost(partKey, hostUri);
    }

    public HostBinding injectHost(Value partKey, Uri hostUri, HostBinding host) {
        return this.meshContext.injectHost(partKey, hostUri, host);
    }

    public Log openHostLog(Value partKey, Uri hostUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openHostLog(this.meshUri(), partKey, hostUri) : null;
    }

    public Policy openHostPolicy(Value partKey, Uri hostUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openHostPolicy(this.meshUri(), partKey, hostUri) : null;
    }

    public Stage openHostStage(Value partKey, Uri hostUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openHostStage(this.meshUri(), partKey, hostUri) : null;
    }

    public StoreBinding openHostStore(Value partKey, Uri hostUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openHostStore(this.meshUri(), partKey, hostUri) : null;
    }

    public NodeDef getNodeDef(Value partKey, Uri hostUri, Uri nodeUri) {
        NodeDef nodeDef;
        MeshDef meshDef = this.meshDef;
        NodeDef nodeDef2 = nodeDef = meshDef != null ? meshDef.getNodeDef(nodeUri) : null;
        if (nodeDef == null) {
            Fabric edge = this.fabricEdge();
            nodeDef = edge != null ? edge.getNodeDef(this.meshUri(), partKey, hostUri, nodeUri) : null;
        }
        return nodeDef;
    }

    public NodeBinding createNode(Value partKey, Uri hostUri, Uri nodeUri) {
        NodeBinding node = this.meshContext.createNode(partKey, hostUri, nodeUri);
        if (node == null && !this.meshUri().isDefined()) {
            NodeDef nodeDef;
            MeshDef meshDef = this.meshDef;
            NodeDef nodeDef2 = nodeDef = meshDef != null ? meshDef.getNodeDef(nodeUri) : null;
            if (nodeDef != null) {
                Value props = nodeDef.props(nodeUri);
                node = new AgentModel(props);
            }
        }
        return node;
    }

    public NodeBinding injectNode(Value partKey, Uri hostUri, Uri nodeUri, NodeBinding node) {
        return this.meshContext.injectNode(partKey, hostUri, nodeUri, node);
    }

    public Log openNodeLog(Value partKey, Uri hostUri, Uri nodeUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openNodeLog(this.meshUri(), partKey, hostUri, nodeUri) : null;
    }

    public Policy openNodePolicy(Value partKey, Uri hostUri, Uri nodeUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openNodePolicy(this.meshUri(), partKey, hostUri, nodeUri) : null;
    }

    public Stage openNodeStage(Value partKey, Uri hostUri, Uri nodeUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openNodeStage(this.meshUri(), partKey, hostUri, nodeUri) : null;
    }

    public StoreBinding openNodeStore(Value partKey, Uri hostUri, Uri nodeUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openNodeStore(this.meshUri(), partKey, hostUri, nodeUri) : null;
    }

    public LaneDef getLaneDef(Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        LaneDef laneDef;
        MeshDef meshDef = this.meshDef;
        LaneDef laneDef2 = laneDef = meshDef != null ? meshDef.getLaneDef(laneUri) : null;
        if (laneDef == null) {
            Fabric edge = this.fabricEdge();
            laneDef = edge != null ? edge.getLaneDef(this.meshUri(), partKey, hostUri, nodeUri, laneUri) : null;
        }
        return laneDef;
    }

    public LaneBinding createLane(Value partKey, Uri hostUri, Uri nodeUri, LaneDef laneDef) {
        return this.meshContext.createLane(partKey, hostUri, nodeUri, laneDef);
    }

    public LaneBinding createLane(Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        return this.meshContext.createLane(partKey, hostUri, nodeUri, laneUri);
    }

    public LaneBinding injectLane(Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri, LaneBinding lane) {
        return this.meshContext.injectLane(partKey, hostUri, nodeUri, laneUri, lane);
    }

    public void openLanes(Value partKey, Uri hostUri, Uri nodeUri, NodeBinding node) {
        this.meshContext.openLanes(partKey, hostUri, nodeUri, node);
    }

    public Log openLaneLog(Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openLaneLog(this.meshUri(), partKey, hostUri, nodeUri, laneUri) : null;
    }

    public Policy openLanePolicy(Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openLanePolicy(this.meshUri(), partKey, hostUri, nodeUri, laneUri) : null;
    }

    public Stage openLaneStage(Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openLaneStage(this.meshUri(), partKey, hostUri, nodeUri, laneUri) : null;
    }

    public StoreBinding openLaneStore(Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri) {
        Fabric edge = this.fabricEdge();
        return edge != null ? edge.openLaneStore(this.meshUri(), partKey, hostUri, nodeUri, laneUri) : null;
    }

    public AgentFactory<?> createAgentFactory(Value partKey, Uri hostUri, Uri nodeUri, AgentDef agentDef) {
        return this.meshContext.createAgentFactory(partKey, hostUri, nodeUri, agentDef);
    }

    public <A extends Agent> AgentFactory<A> createAgentFactory(Value partKey, Uri hostUri, Uri nodeUri, Class<? extends A> agentClass) {
        return this.meshContext.createAgentFactory(partKey, hostUri, nodeUri, agentClass);
    }

    public void openAgents(Value partKey, Uri hostUri, Uri nodeUri, NodeBinding node) {
        this.meshContext.openAgents(partKey, hostUri, nodeUri, node);
        if (!this.meshUri().isDefined()) {
            NodeDef nodeDef;
            MeshDef meshDef = this.meshDef;
            NodeDef nodeDef2 = nodeDef = meshDef != null ? meshDef.getNodeDef(nodeUri) : null;
            if (nodeDef != null && node instanceof AgentModel) {
                AgentModel agentModel = (AgentModel)node;
                for (AgentDef agentDef : nodeDef.agentDefs()) {
                    AgentFactory<?> agentFactory = this.createAgentFactory(partKey, hostUri, nodeUri, agentDef);
                    if (agentDef == null) continue;
                    Value props = agentDef.props();
                    if (!props.isDefined()) {
                        props = agentModel.props();
                    }
                    agentModel.addAgentView(agentModel.createAgent(agentFactory, props));
                }
            }
        }
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        return this.meshContext.authenticate(credentials);
    }

    public void didClose() {
        this.meshBinding.didClose();
    }

    public void didFail(Throwable error) {
        this.meshBinding.didFail(error);
    }
}

