/*
 * Decompiled with CFR 0.152.
 */
package swim.fabric;

import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.collections.HashTrieMap;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.fabric.FabricHost;
import swim.fabric.FabricLane;
import swim.fabric.FabricTier;
import swim.runtime.CellBinding;
import swim.runtime.CellContext;
import swim.runtime.HostBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LogDef;
import swim.runtime.NodeBinding;
import swim.runtime.NodeContext;
import swim.runtime.NodeDef;
import swim.runtime.PolicyDef;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;

public class FabricNode
extends FabricTier
implements NodeBinding,
NodeContext {
    final NodeBinding nodeBinding;
    NodeContext nodeContext;
    NodeDef nodeDef;

    public FabricNode(NodeBinding nodeBinding, NodeDef nodeDef) {
        this.nodeBinding = nodeBinding;
        this.nodeDef = nodeDef;
    }

    public final NodeDef nodeDef() {
        return this.nodeDef;
    }

    public final FabricHost fabricHost() {
        return (FabricHost)this.host().unwrapHost(FabricHost.class);
    }

    public final HostBinding host() {
        return this.nodeContext.host();
    }

    public final NodeBinding nodeWrapper() {
        return this.nodeBinding.nodeWrapper();
    }

    public final NodeBinding nodeBinding() {
        return this.nodeBinding;
    }

    public final NodeContext nodeContext() {
        return this.nodeContext;
    }

    public void setNodeContext(NodeContext nodeContext) {
        this.nodeContext = nodeContext;
        this.nodeBinding.setNodeContext((NodeContext)this);
    }

    public <T> T unwrapNode(Class<T> nodeClass) {
        if (nodeClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return (T)this.nodeContext.unwrapNode(nodeClass);
    }

    @Override
    public final CellBinding cellBinding() {
        return this.nodeBinding;
    }

    @Override
    public final CellContext cellContext() {
        return this.nodeContext;
    }

    public Value partKey() {
        return this.nodeContext.partKey();
    }

    public Uri hostUri() {
        return this.nodeContext.hostUri();
    }

    public Uri nodeUri() {
        return this.nodeContext.nodeUri();
    }

    public long createdTime() {
        return this.nodeBinding.createdTime();
    }

    public Identity identity() {
        return this.nodeContext.identity();
    }

    public HashTrieMap<Uri, LaneBinding> lanes() {
        return this.nodeBinding.lanes();
    }

    public LaneBinding getLane(Uri laneUri) {
        return this.nodeBinding.getLane(laneUri);
    }

    public Log createLog(LogDef logDef) {
        FabricHost host = this.fabricHost();
        return host != null ? host.createLog(logDef) : null;
    }

    public Log injectLog(Log log) {
        FabricHost host = this.fabricHost();
        return host != null ? host.injectLog(log) : log;
    }

    @Override
    protected Log openLog() {
        Log log = this.nodeDef != null && this.nodeDef.logDef() != null ? this.createLog(this.nodeDef.logDef()) : this.openNodeLog();
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        FabricHost host = this.fabricHost();
        return host != null ? host.createPolicy(policyDef) : null;
    }

    public Policy injectPolicy(Policy policy) {
        FabricHost host = this.fabricHost();
        return host != null ? host.injectPolicy(policy) : policy;
    }

    @Override
    protected Policy openPolicy() {
        Policy policy = this.nodeDef != null && this.nodeDef.policyDef() != null ? this.createPolicy(this.nodeDef.policyDef()) : this.openNodePolicy();
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return policy;
    }

    public Stage createStage(StageDef stageDef) {
        FabricHost host = this.fabricHost();
        return host != null ? host.createStage(stageDef) : null;
    }

    public Stage injectStage(Stage stage) {
        FabricHost host = this.fabricHost();
        return host != null ? host.injectStage(stage) : stage;
    }

    @Override
    protected Stage openStage() {
        Stage stage = this.nodeDef != null && this.nodeDef.stageDef() != null ? this.createStage(this.nodeDef.stageDef()) : this.openNodeStage();
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        FabricHost host = this.fabricHost();
        return host != null ? host.createStore(storeDef) : null;
    }

    public StoreBinding injectStore(StoreBinding store) {
        FabricHost host = this.fabricHost();
        return host != null ? host.injectStore(store) : store;
    }

    @Override
    protected StoreBinding openStore() {
        StoreBinding hostStore;
        StoreBinding store = null;
        store = this.nodeDef != null && this.nodeDef.storeDef() != null ? this.createStore(this.nodeDef.storeDef()) : this.openNodeStore();
        if (store == null && (hostStore = this.host().hostContext().store()) != null) {
            store = hostStore.storeContext().openStore((Value)Record.create((int)1).slot("node", this.nodeUri().toString()));
        }
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    protected Log openNodeLog() {
        FabricHost host = this.fabricHost();
        return host != null ? host.openNodeLog(this.nodeUri()) : null;
    }

    protected Policy openNodePolicy() {
        FabricHost host = this.fabricHost();
        return host != null ? host.openNodePolicy(this.nodeUri()) : null;
    }

    protected Stage openNodeStage() {
        FabricHost host = this.fabricHost();
        return host != null ? host.openNodeStage(this.nodeUri()) : null;
    }

    protected StoreBinding openNodeStore() {
        FabricHost host = this.fabricHost();
        return host != null ? host.openNodeStore(this.nodeUri()) : null;
    }

    public LaneBinding openLane(Uri laneUri) {
        return this.nodeBinding.openLane(laneUri);
    }

    public LaneBinding openLane(Uri laneUri, LaneBinding lane) {
        return this.nodeBinding.openLane(laneUri, lane);
    }

    public LaneDef getLaneDef(Uri laneUri) {
        LaneDef laneDef;
        NodeDef nodeDef = this.nodeDef;
        LaneDef laneDef2 = laneDef = nodeDef != null ? nodeDef.getLaneDef(laneUri) : null;
        if (laneDef == null) {
            FabricHost host = this.fabricHost();
            laneDef = host != null ? host.getLaneDef(this.nodeUri(), laneUri) : null;
        }
        return laneDef;
    }

    public LaneBinding createLane(LaneDef laneDef) {
        return this.nodeContext.createLane(laneDef);
    }

    public LaneBinding createLane(Uri laneUri) {
        return this.nodeContext.createLane(laneUri);
    }

    public LaneBinding injectLane(Uri laneUri, LaneBinding lane) {
        LaneDef laneDef = this.getLaneDef(laneUri);
        return new FabricLane(this.nodeContext.injectLane(laneUri, lane), laneDef);
    }

    public void openLanes(NodeBinding node) {
        this.nodeContext.openLanes(node);
        NodeDef nodeDef = this.nodeDef;
        if (nodeDef != null) {
            for (LaneDef laneDef : nodeDef.laneDefs()) {
                Uri laneUri = laneDef.laneUri();
                LaneBinding lane = this.createLane(laneDef);
                if (laneDef == null) continue;
                node.openLane(laneUri, lane);
            }
        }
    }

    public Log openLaneLog(Uri laneUri) {
        FabricHost host = this.fabricHost();
        return host != null ? host.openLaneLog(this.nodeUri(), laneUri) : null;
    }

    public Policy openLanePolicy(Uri laneUri) {
        FabricHost host = this.fabricHost();
        return host != null ? host.openLanePolicy(this.nodeUri(), laneUri) : null;
    }

    public Stage openLaneStage(Uri laneUri) {
        FabricHost host = this.fabricHost();
        return host != null ? host.openLaneStage(this.nodeUri(), laneUri) : null;
    }

    public StoreBinding openLaneStore(Uri laneUri) {
        FabricHost host = this.fabricHost();
        return host != null ? host.openLaneStore(this.nodeUri(), laneUri) : null;
    }

    public AgentFactory<?> createAgentFactory(AgentDef agentDef) {
        return this.nodeContext.createAgentFactory(agentDef);
    }

    public <A extends Agent> AgentFactory<A> createAgentFactory(Class<? extends A> agentClass) {
        return this.nodeContext.createAgentFactory(agentClass);
    }

    public void openAgents(NodeBinding node) {
        this.nodeContext.openAgents(node);
    }

    public void didClose() {
        this.nodeBinding.didClose();
    }

    public void didFail(Throwable error) {
        this.nodeBinding.didFail(error);
    }
}

