/*
 * Decompiled with CFR 0.152.
 */
package swim.fabric;

import java.util.Collection;
import swim.api.agent.AgentDef;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.FingerTrieSeq;
import swim.concurrent.StageDef;
import swim.runtime.LaneDef;
import swim.runtime.LogDef;
import swim.runtime.NodeDef;
import swim.runtime.PolicyDef;
import swim.store.StoreDef;
import swim.uri.Uri;
import swim.uri.UriMapper;
import swim.uri.UriPattern;
import swim.util.Murmur3;

public class FabricNodeDef
implements NodeDef,
Debug {
    final UriPattern nodePattern;
    final FingerTrieSeq<AgentDef> agentDefs;
    final UriMapper<LaneDef> laneDefs;
    final LogDef logDef;
    final PolicyDef policyDef;
    final StageDef stageDef;
    final StoreDef storeDef;
    private static int hashSeed;

    public FabricNodeDef(UriPattern nodePattern, FingerTrieSeq<AgentDef> agentDefs, UriMapper<LaneDef> laneDefs, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        this.nodePattern = nodePattern;
        this.agentDefs = agentDefs;
        this.laneDefs = laneDefs;
        this.logDef = logDef;
        this.policyDef = policyDef;
        this.stageDef = stageDef;
        this.storeDef = storeDef;
    }

    public final Uri nodeUri() {
        return this.nodePattern.isUri() ? this.nodePattern.toUri() : null;
    }

    public final UriPattern nodePattern() {
        return this.nodePattern;
    }

    public FabricNodeDef nodePattern(UriPattern nodePattern) {
        return this.copy(nodePattern, this.agentDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends AgentDef> agentDefs() {
        return this.agentDefs;
    }

    public final AgentDef getAgentDef(String agentName) {
        for (AgentDef agentDef : this.agentDefs) {
            if (!agentName.equals(agentDef.agentName())) continue;
            return agentDef;
        }
        return null;
    }

    public FabricNodeDef agentDef(AgentDef agentDef) {
        return this.copy(this.nodePattern, (FingerTrieSeq<AgentDef>)this.agentDefs.appended((Object)agentDef), this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends LaneDef> laneDefs() {
        return this.laneDefs.values();
    }

    public final LaneDef getLaneDef(Uri laneUri) {
        return (LaneDef)this.laneDefs.get(laneUri);
    }

    public FabricNodeDef laneDef(LaneDef laneDef) {
        return this.copy(this.nodePattern, this.agentDefs, (UriMapper<LaneDef>)this.laneDefs.updated(laneDef.lanePattern(), (Object)laneDef), this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final LogDef logDef() {
        return this.logDef;
    }

    public FabricNodeDef logDef(LogDef logDef) {
        return this.copy(this.nodePattern, this.agentDefs, this.laneDefs, logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final PolicyDef policyDef() {
        return this.policyDef;
    }

    public FabricNodeDef policyDef(PolicyDef policyDef) {
        return this.copy(this.nodePattern, this.agentDefs, this.laneDefs, this.logDef, policyDef, this.stageDef, this.storeDef);
    }

    public final StageDef stageDef() {
        return this.stageDef;
    }

    public FabricNodeDef stageDef(StageDef stageDef) {
        return this.copy(this.nodePattern, this.agentDefs, this.laneDefs, this.logDef, this.policyDef, stageDef, this.storeDef);
    }

    public final StoreDef storeDef() {
        return this.storeDef;
    }

    public FabricNodeDef storeDef(StoreDef storeDef) {
        return this.copy(this.nodePattern, this.agentDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, storeDef);
    }

    protected FabricNodeDef copy(UriPattern nodePattern, FingerTrieSeq<AgentDef> agentDefs, UriMapper<LaneDef> laneDefs, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        return new FabricNodeDef(nodePattern, agentDefs, laneDefs, logDef, policyDef, stageDef, storeDef);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FabricNodeDef) {
            FabricNodeDef that = (FabricNodeDef)other;
            return this.nodePattern.equals((Object)that.nodePattern) && this.agentDefs.equals(that.agentDefs) && this.laneDefs.equals(that.laneDefs) && (this.logDef == null ? that.logDef == null : this.logDef.equals(that.logDef)) && (this.policyDef == null ? that.policyDef == null : this.policyDef.equals(that.policyDef)) && (this.stageDef == null ? that.stageDef == null : this.stageDef.equals(that.stageDef)) && (this.storeDef == null ? that.storeDef == null : this.storeDef.equals(that.storeDef));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(FabricNodeDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.nodePattern.hashCode()), (int)this.agentDefs.hashCode()), (int)this.laneDefs.hashCode()), (int)Murmur3.hash((Object)this.logDef)), (int)Murmur3.hash((Object)this.policyDef)), (int)Murmur3.hash((Object)this.stageDef)), (int)Murmur3.hash((Object)this.storeDef)));
    }

    public void debug(Output<?> output) {
        output = output.write("FabricNodeDef").write(46);
        output = this.nodePattern.isUri() ? output.write("fromNodeUri").write(40).debug((Object)this.nodePattern.toUri()).write(41) : output.write("fromNodePattern").write(40).debug((Object)this.nodePattern).write(41);
        for (AgentDef agentDef : this.agentDefs()) {
            output = output.write(46).write("agentDef").write(40).debug((Object)agentDef).write(41);
        }
        for (LaneDef laneDef : this.laneDefs.values()) {
            output = output.write(46).write("laneDef").write(40).debug((Object)laneDef).write(41);
        }
        if (this.logDef != null) {
            output = output.write(46).write("logDef").write(40).debug((Object)this.logDef).write(41);
        }
        if (this.policyDef != null) {
            output = output.write(46).write("policyDef").write(40).debug((Object)this.policyDef).write(41);
        }
        if (this.stageDef != null) {
            output = output.write(46).write("stageDef").write(40).debug((Object)this.stageDef).write(41);
        }
        if (this.storeDef != null) {
            output = output.write(46).write("storeDef").write(40).debug((Object)this.storeDef).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static FabricNodeDef fromNodeUri(Uri nodeUri) {
        return new FabricNodeDef(UriPattern.from((Uri)nodeUri), (FingerTrieSeq<AgentDef>)FingerTrieSeq.empty(), (UriMapper<LaneDef>)UriMapper.empty(), null, null, null, null);
    }

    public static FabricNodeDef fromNodeUri(String nodeUri) {
        return FabricNodeDef.fromNodeUri(Uri.parse((String)nodeUri));
    }

    public static FabricNodeDef fromNodePattern(UriPattern nodePattern) {
        return new FabricNodeDef(nodePattern, (FingerTrieSeq<AgentDef>)FingerTrieSeq.empty(), (UriMapper<LaneDef>)UriMapper.empty(), null, null, null, null);
    }

    public static FabricNodeDef fromNodePattern(String nodePattern) {
        return FabricNodeDef.fromNodePattern(UriPattern.parse((String)nodePattern));
    }
}

