/*
 * Decompiled with CFR 0.152.
 */
package swim.fabric;

import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.collections.HashTrieMap;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.fabric.FabricHost;
import swim.fabric.FabricMesh;
import swim.fabric.FabricTier;
import swim.runtime.CellBinding;
import swim.runtime.CellContext;
import swim.runtime.HostBinding;
import swim.runtime.HostDef;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LogDef;
import swim.runtime.MeshBinding;
import swim.runtime.NodeBinding;
import swim.runtime.NodeDef;
import swim.runtime.PartBinding;
import swim.runtime.PartContext;
import swim.runtime.PartDef;
import swim.runtime.PartPredicate;
import swim.runtime.PolicyDef;
import swim.runtime.agent.AgentModel;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;

public class FabricPart
extends FabricTier
implements PartBinding,
PartContext {
    final PartBinding partBinding;
    PartContext partContext;
    PartDef partDef;

    public FabricPart(PartBinding partBinding, PartDef partDef) {
        this.partBinding = partBinding;
        this.partDef = partDef;
    }

    public final PartDef partDef() {
        return this.partDef;
    }

    public final FabricMesh fabricMesh() {
        return (FabricMesh)this.mesh().unwrapMesh(FabricMesh.class);
    }

    public final MeshBinding mesh() {
        return this.partContext.mesh();
    }

    public final PartBinding partWrapper() {
        return this.partBinding.partWrapper();
    }

    public final PartBinding partBinding() {
        return this.partBinding;
    }

    public final PartContext partContext() {
        return this.partContext;
    }

    public void setPartContext(PartContext partContext) {
        this.partContext = partContext;
        this.partBinding.setPartContext((PartContext)this);
    }

    public <T> T unwrapPart(Class<T> partClass) {
        if (partClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return (T)this.partContext.unwrapPart(partClass);
    }

    @Override
    public final CellBinding cellBinding() {
        return this.partBinding;
    }

    @Override
    public final CellContext cellContext() {
        return this.partContext;
    }

    public Value partKey() {
        return this.partContext.partKey();
    }

    public PartPredicate predicate() {
        return this.partBinding.predicate();
    }

    public HostBinding master() {
        return this.partBinding.master();
    }

    public void setMaster(HostBinding master) {
        this.partBinding.setMaster(master);
    }

    public HashTrieMap<Uri, HostBinding> hosts() {
        return this.partBinding.hosts();
    }

    public HostBinding getHost(Uri hostUri) {
        return this.partBinding.getHost(hostUri);
    }

    public HostBinding openHost(Uri hostUri) {
        return this.partBinding.openHost(hostUri);
    }

    public HostBinding openHost(Uri hostUri, HostBinding host) {
        return this.partBinding.openHost(hostUri, host);
    }

    public void hostDidConnect(Uri hostUri) {
        this.partContext.hostDidConnect(hostUri);
    }

    public void hostDidDisconnect(Uri hostUri) {
        this.partContext.hostDidDisconnect(hostUri);
    }

    public void reopenUplinks() {
        this.partBinding.reopenUplinks();
    }

    public Log createLog(LogDef logDef) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.createLog(logDef) : null;
    }

    public Log injectLog(Log log) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.injectLog(log) : log;
    }

    @Override
    protected Log openLog() {
        Log log = this.partDef != null && this.partDef.logDef() != null ? this.createLog(this.partDef.logDef()) : this.openPartLog();
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.createPolicy(policyDef) : null;
    }

    public Policy injectPolicy(Policy policy) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.injectPolicy(policy) : policy;
    }

    @Override
    protected Policy openPolicy() {
        Policy policy = this.partDef != null && this.partDef.policyDef() != null ? this.createPolicy(this.partDef.policyDef()) : this.openPartPolicy();
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return policy;
    }

    public Stage createStage(StageDef stageDef) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.createStage(stageDef) : null;
    }

    public Stage injectStage(Stage stage) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.injectStage(stage) : stage;
    }

    @Override
    protected Stage openStage() {
        Stage stage = this.partDef != null && this.partDef.stageDef() != null ? this.createStage(this.partDef.stageDef()) : this.openPartStage();
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.createStore(storeDef) : null;
    }

    public StoreBinding injectStore(StoreBinding store) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.injectStore(store) : store;
    }

    @Override
    protected StoreBinding openStore() {
        StoreBinding store = null;
        store = this.partDef != null && this.partDef.storeDef() != null ? this.createStore(this.partDef.storeDef()) : this.openPartStore();
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    protected Log openPartLog() {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openPartLog(this.partKey()) : null;
    }

    protected Policy openPartPolicy() {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openPartPolicy(this.partKey()) : null;
    }

    protected Stage openPartStage() {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openPartStage(this.partKey()) : null;
    }

    protected StoreBinding openPartStore() {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openPartStore(this.partKey()) : null;
    }

    public HostDef getHostDef(Uri hostUri) {
        HostDef hostDef;
        PartDef partDef = this.partDef;
        HostDef hostDef2 = hostDef = partDef != null ? partDef.getHostDef(hostUri) : null;
        if (hostDef == null) {
            FabricMesh mesh = this.fabricMesh();
            hostDef = mesh != null ? mesh.getHostDef(this.partKey(), hostUri) : null;
        }
        return hostDef;
    }

    public HostBinding createHost(Uri hostUri) {
        return this.partContext.createHost(hostUri);
    }

    public HostBinding injectHost(Uri hostUri, HostBinding host) {
        HostDef hostDef = this.getHostDef(hostUri);
        return new FabricHost(this.partContext.injectHost(hostUri, host), hostDef);
    }

    public Log openHostLog(Uri hostUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openHostLog(this.partKey(), hostUri) : null;
    }

    public Policy openHostPolicy(Uri hostUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openHostPolicy(this.partKey(), hostUri) : null;
    }

    public Stage openHostStage(Uri hostUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openHostStage(this.partKey(), hostUri) : null;
    }

    public StoreBinding openHostStore(Uri hostUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openHostStore(this.partKey(), hostUri) : null;
    }

    public NodeDef getNodeDef(Uri hostUri, Uri nodeUri) {
        NodeDef nodeDef;
        PartDef partDef = this.partDef;
        NodeDef nodeDef2 = nodeDef = partDef != null ? partDef.getNodeDef(nodeUri) : null;
        if (nodeDef == null) {
            FabricMesh mesh = this.fabricMesh();
            nodeDef = mesh != null ? mesh.getNodeDef(this.partKey(), hostUri, nodeUri) : null;
        }
        return nodeDef;
    }

    public NodeBinding createNode(Uri hostUri, Uri nodeUri) {
        NodeBinding node = this.partContext.createNode(hostUri, nodeUri);
        if (node == null && !this.meshUri().isDefined()) {
            NodeDef nodeDef;
            PartDef partDef = this.partDef;
            NodeDef nodeDef2 = nodeDef = partDef != null ? partDef.getNodeDef(nodeUri) : null;
            if (nodeDef != null) {
                Value props = nodeDef.props(nodeUri);
                node = new AgentModel(props);
            }
        }
        return node;
    }

    public NodeBinding injectNode(Uri hostUri, Uri nodeUri, NodeBinding node) {
        return this.partContext.injectNode(hostUri, nodeUri, node);
    }

    public Log openNodeLog(Uri hostUri, Uri nodeUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openNodeLog(this.partKey(), hostUri, nodeUri) : null;
    }

    public Policy openNodePolicy(Uri hostUri, Uri nodeUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openNodePolicy(this.partKey(), hostUri, nodeUri) : null;
    }

    public Stage openNodeStage(Uri hostUri, Uri nodeUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openNodeStage(this.partKey(), hostUri, nodeUri) : null;
    }

    public StoreBinding openNodeStore(Uri hostUri, Uri nodeUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openNodeStore(this.partKey(), hostUri, nodeUri) : null;
    }

    public LaneDef getLaneDef(Uri hostUri, Uri nodeUri, Uri laneUri) {
        LaneDef laneDef;
        PartDef partDef = this.partDef;
        LaneDef laneDef2 = laneDef = partDef != null ? partDef.getLaneDef(laneUri) : null;
        if (laneDef == null) {
            FabricMesh mesh = this.fabricMesh();
            laneDef = mesh != null ? mesh.getLaneDef(this.partKey(), hostUri, nodeUri, laneUri) : null;
        }
        return laneDef;
    }

    public LaneBinding createLane(Uri hostUri, Uri nodeUri, LaneDef laneDef) {
        return this.partContext.createLane(hostUri, nodeUri, laneDef);
    }

    public LaneBinding createLane(Uri hostUri, Uri nodeUri, Uri laneUri) {
        return this.partContext.createLane(hostUri, nodeUri, laneUri);
    }

    public LaneBinding injectLane(Uri hostUri, Uri nodeUri, Uri laneUri, LaneBinding lane) {
        return this.partContext.injectLane(hostUri, nodeUri, laneUri, lane);
    }

    public void openLanes(Uri hostUri, Uri nodeUri, NodeBinding node) {
        this.partContext.openLanes(hostUri, nodeUri, node);
    }

    public Log openLaneLog(Uri hostUri, Uri nodeUri, Uri laneUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openLaneLog(this.partKey(), hostUri, nodeUri, laneUri) : null;
    }

    public Policy openLanePolicy(Uri hostUri, Uri nodeUri, Uri laneUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openLanePolicy(this.partKey(), hostUri, nodeUri, laneUri) : null;
    }

    public Stage openLaneStage(Uri hostUri, Uri nodeUri, Uri laneUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openLaneStage(this.partKey(), hostUri, nodeUri, laneUri) : null;
    }

    public StoreBinding openLaneStore(Uri hostUri, Uri nodeUri, Uri laneUri) {
        FabricMesh mesh = this.fabricMesh();
        return mesh != null ? mesh.openLaneStore(this.partKey(), hostUri, nodeUri, laneUri) : null;
    }

    public AgentFactory<?> createAgentFactory(Uri hostUri, Uri nodeUri, AgentDef agentDef) {
        return this.partContext.createAgentFactory(hostUri, nodeUri, agentDef);
    }

    public <A extends Agent> AgentFactory<A> createAgentFactory(Uri hostUri, Uri nodeUri, Class<? extends A> agentClass) {
        return this.partContext.createAgentFactory(hostUri, nodeUri, agentClass);
    }

    public void openAgents(Uri hostUri, Uri nodeUri, NodeBinding node) {
        this.partContext.openAgents(hostUri, nodeUri, node);
        if (!this.meshUri().isDefined()) {
            NodeDef nodeDef;
            PartDef partDef = this.partDef;
            NodeDef nodeDef2 = nodeDef = partDef != null ? partDef.getNodeDef(nodeUri) : null;
            if (nodeDef != null && node instanceof AgentModel) {
                AgentModel agentModel = (AgentModel)node;
                for (AgentDef agentDef : nodeDef.agentDefs()) {
                    AgentFactory<?> agentFactory = this.createAgentFactory(hostUri, nodeUri, agentDef);
                    if (agentDef == null) continue;
                    Value props = agentDef.props();
                    if (!props.isDefined()) {
                        props = agentModel.props();
                    }
                    agentModel.addAgentView(agentModel.createAgent(agentFactory, props));
                }
            }
        }
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        return this.partContext.authenticate(credentials);
    }

    public void didClose() {
        this.partBinding.didClose();
    }

    public void didFail(Throwable error) {
        this.partBinding.didFail(error);
    }
}

