/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.json.JsonWriter;
import swim.structure.Absent;
import swim.structure.Attr;
import swim.structure.Bool;
import swim.structure.Data;
import swim.structure.Extant;
import swim.structure.Field;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;

public class JsonStructureWriter
extends JsonWriter<Item, Value> {
    @Override
    public Iterator<Item> items(Item item) {
        return item.iterator();
    }

    @Override
    public Item item(Value value) {
        return value;
    }

    @Override
    public Value key(Item item) {
        return item.key();
    }

    @Override
    public Value value(Item item) {
        return item.toValue();
    }

    @Override
    public Writer<?, ?> writeItem(Item item, Output<?> output) {
        if (item instanceof Field) {
            if (item instanceof Attr) {
                Attr that = (Attr)item;
                return this.writeField(Text.from((String)('@' + that.key().stringValue())), that.value(), output);
            }
            if (item instanceof Slot) {
                Slot that = (Slot)item;
                if (that.key() instanceof Text) {
                    return this.writeField(that.key(), that.value(), output);
                }
                return this.writeValue((Value)Record.of((Object[])new Object[]{Slot.of((String)"$key", (Value)that.key()), Slot.of((String)"$value", (Value)that.value())}), output);
            }
        } else if (item instanceof Value) {
            return this.writeValue((Value)item, output);
        }
        return Writer.error((Throwable)new WriterException("No JSON serialization for " + item));
    }

    @Override
    public Writer<?, ?> writeField(Item item, Output<?> output, int index) {
        if (item instanceof Field) {
            if (item instanceof Attr) {
                Attr that = (Attr)item;
                return this.writeField(Text.from((String)('@' + that.key().stringValue())), that.value(), output);
            }
            if (item instanceof Slot) {
                Slot that = (Slot)item;
                if (that.key() instanceof Text) {
                    return this.writeField(that.key(), that.value(), output);
                }
                return this.writeField(Text.from((String)("$" + index)), Record.of((Object[])new Object[]{Slot.of((String)"$key", (Value)that.key()), Slot.of((String)"$value", (Value)that.value())}), output);
            }
        } else if (item instanceof Value) {
            return this.writeItem((Item)Slot.of((Value)Text.from((String)("$" + index)), (Value)((Value)item)), output);
        }
        return Writer.error((Throwable)new WriterException("No JSON serialization for " + item));
    }

    @Override
    public Writer<?, ?> writeValue(Item item, Output<?> output, int index) {
        if (item instanceof Field) {
            return this.writeValue(item.toValue(), output);
        }
        if (item instanceof Value) {
            return this.writeValue((Value)item, output);
        }
        return Writer.error((Throwable)new WriterException("No JSON serialization for " + item));
    }

    @Override
    public Writer<?, ?> writeValue(Value value, Output<?> output) {
        if (value instanceof Record) {
            Record that = (Record)value;
            if (that.isArray()) {
                return this.writeArray(that, output);
            }
            return this.writeObject(that, output);
        }
        if (value instanceof Data) {
            Data that = (Data)value;
            return this.writeData(that.asByteBuffer(), output);
        }
        if (value instanceof Text) {
            Text that = (Text)value;
            return this.writeText(that.stringValue(), output);
        }
        if (value instanceof Num) {
            Num that = (Num)value;
            if (that.isUint32()) {
                return this.writeUint32(that.intValue(), output);
            }
            if (that.isUint64()) {
                return this.writeUint64(that.longValue(), output);
            }
            if (that.isValidInt()) {
                return this.writeNum(that.intValue(), output);
            }
            if (that.isValidLong()) {
                return this.writeNum(that.longValue(), output);
            }
            if (that.isValidFloat()) {
                return this.writeNum(that.floatValue(), output);
            }
            if (that.isValidDouble()) {
                return this.writeNum(that.doubleValue(), output);
            }
            if (that.isValidInteger()) {
                return this.writeNum(that.integerValue(), output);
            }
        } else {
            if (value instanceof Bool) {
                Bool that = (Bool)value;
                return this.writeBool(that.booleanValue(), output);
            }
            if (value instanceof Extant) {
                return this.writeNull(output);
            }
            if (value instanceof Absent) {
                return this.writeUndefined(output);
            }
        }
        return Writer.error((Throwable)new WriterException("No JSON serialization for " + value));
    }
}

