/*
 * Decompiled with CFR 0.152.
 */
package swim.linker;

import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieSet;
import swim.linker.GoogleIdAuthDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Builder;

final class GoogleIdAuthForm
extends Form<GoogleIdAuthDef> {
    GoogleIdAuthForm() {
    }

    public String tag() {
        return "googleId";
    }

    public Class<?> type() {
        return GoogleIdAuthDef.class;
    }

    public Item mold(GoogleIdAuthDef authDef) {
        if (authDef != null) {
            Record record = Record.create().attr(this.tag());
            for (String audience : authDef.audiences) {
                record.add((Item)Record.create((int)1).attr("audience", audience));
            }
            for (String email : authDef.emails) {
                record.add((Item)Record.create((int)1).attr("email", email));
            }
            return record;
        }
        return Item.extant();
    }

    public GoogleIdAuthDef cast(Item item) {
        Value value = item.toValue();
        Value headers = value.getAttr(this.tag());
        if (headers.isDefined()) {
            Builder audiences = FingerTrieSeq.builder();
            HashTrieSet emails = HashTrieSet.empty();
            for (Item member : value) {
                String tag = member.tag();
                if ("audience".equals(tag)) {
                    audiences.add((Object)member.get("audience").stringValue());
                    continue;
                }
                if (!"email".equals(tag)) continue;
                emails = emails.added((Object)member.get("email").stringValue());
            }
            return new GoogleIdAuthDef((FingerTrieSeq<String>)((FingerTrieSeq)audiences.bind()), (HashTrieSet<String>)emails);
        }
        return null;
    }
}

