/*
 * Decompiled with CFR 0.152.
 */
package swim.linker;

import swim.io.warp.WarpSettings;
import swim.linker.HttpsServiceDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

final class HttpsServiceForm
extends Form<HttpsServiceDef> {
    HttpsServiceForm() {
    }

    public String tag() {
        return "https";
    }

    public Class<?> type() {
        return HttpsServiceDef.class;
    }

    public Item mold(HttpsServiceDef serviceDef) {
        if (serviceDef != null) {
            Value headers = Value.absent();
            if (!"0.0.0.0".equals(serviceDef.address)) {
                headers = headers.updated("address", serviceDef.address);
            }
            if (serviceDef.port != 443) {
                headers = headers.updated("port", serviceDef.port);
            }
            if (!headers.isDefined()) {
                headers = Value.extant();
            }
            Record record = Record.create().attr(this.tag(), headers);
            if (serviceDef.planeName != null) {
                record.slot("plane", serviceDef.planeName);
            }
            if (serviceDef.documentRoot != null) {
                record.slot("documentRoot", serviceDef.documentRoot.toString());
            }
            return record.concat((Item)serviceDef.warpSettings.toValue());
        }
        return Item.extant();
    }

    public HttpsServiceDef cast(Item item) {
        Value value = item.toValue();
        Value headers = value.getAttr(this.tag());
        if (headers.isDefined()) {
            String address = headers.get("address").stringValue("0.0.0.0");
            int port = headers.get("port").intValue(443);
            String planeName = value.get("plane").stringValue(null);
            WarpSettings swimSettings = (WarpSettings)WarpSettings.form().cast((Item)value);
            Uri documentRoot = (Uri)value.get("documentRoot").cast(Uri.form());
            return new HttpsServiceDef(address, port, planeName, documentRoot, swimSettings);
        }
        return null;
    }
}

