/*
 * Decompiled with CFR 0.152.
 */
package swim.linker;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.io.warp.WarpSettings;
import swim.linker.AgentTypeDef;
import swim.linker.AuthDef;
import swim.linker.PlaneForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Murmur3;

public final class PlaneDef
implements Debug {
    final String name;
    final String className;
    final HashTrieMap<String, AgentTypeDef> agentTypeDefs;
    final FingerTrieSeq<AuthDef> authDefs;
    final WarpSettings warpSettings;
    final Record record;
    private static int hashSeed;
    private static Form<PlaneDef> form;

    public PlaneDef(String name, String className, HashTrieMap<String, AgentTypeDef> agentTypeDefs, FingerTrieSeq<AuthDef> authDefs, WarpSettings warpSettings) {
        this(name, className, agentTypeDefs, authDefs, warpSettings, Record.empty());
    }

    public PlaneDef(String name, String className, HashTrieMap<String, AgentTypeDef> agentTypeDefs, FingerTrieSeq<AuthDef> authDefs, WarpSettings warpSettings, Record record) {
        this.name = name;
        this.className = className;
        this.agentTypeDefs = agentTypeDefs;
        this.authDefs = authDefs;
        this.warpSettings = warpSettings;
        this.record = record;
    }

    public String name() {
        return this.name;
    }

    public PlaneDef name(String name) {
        return new PlaneDef(name, this.className, this.agentTypeDefs, this.authDefs, this.warpSettings);
    }

    public String className() {
        return this.className;
    }

    public PlaneDef className(String className) {
        return new PlaneDef(this.name, className, this.agentTypeDefs, this.authDefs, this.warpSettings);
    }

    public HashTrieMap<String, AgentTypeDef> agentTypeDefs() {
        return this.agentTypeDefs;
    }

    public AgentTypeDef getAgentTypeDef(String agentName) {
        return (AgentTypeDef)this.agentTypeDefs.get((Object)agentName);
    }

    public PlaneDef agentTypeDef(AgentTypeDef agentTypeDef) {
        return new PlaneDef(this.name, this.className, (HashTrieMap<String, AgentTypeDef>)this.agentTypeDefs.updated((Object)agentTypeDef.name(), (Object)agentTypeDef), this.authDefs, this.warpSettings);
    }

    public FingerTrieSeq<AuthDef> authDefs() {
        return this.authDefs;
    }

    public PlaneDef authDef(AuthDef authDef) {
        return new PlaneDef(this.name, this.className, this.agentTypeDefs, (FingerTrieSeq<AuthDef>)this.authDefs.appended((Object)authDef), this.warpSettings);
    }

    public WarpSettings warpSettings() {
        return this.warpSettings;
    }

    public PlaneDef warpSettings(WarpSettings warpSettings) {
        return new PlaneDef(this.name, this.className, this.agentTypeDefs, this.authDefs, warpSettings);
    }

    public Record record() {
        return this.record;
    }

    public Value toValue() {
        return PlaneDef.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PlaneDef) {
            PlaneDef that = (PlaneDef)other;
            return this.name.equals(that.name) && (this.className == null ? that.className == null : this.className.equals(that.className)) && this.agentTypeDefs.equals(that.agentTypeDefs) && this.authDefs.equals(that.authDefs) && this.warpSettings.equals((Object)that.warpSettings);
        }
        return false;
    }

    public int hashCode() {
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)Murmur3.hash((Object)this.className)), (int)this.agentTypeDefs.hashCode()), (int)this.authDefs.hashCode()), (int)this.warpSettings.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("new").write(32).write("PlaneDef").write(40).debug((Object)this.name).write(", ").debug(this.agentTypeDefs).write(", ").debug(this.authDefs).write(", ").debug((Object)this.warpSettings).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    @Kind
    public static Form<PlaneDef> form() {
        if (form == null) {
            form = new PlaneForm();
        }
        return form;
    }
}

