/*
 * Decompiled with CFR 0.152.
 */
package swim.linker;

import java.util.Collection;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.io.TlsSettings;
import swim.io.warp.WarpSettings;
import swim.linker.AgentTypeDef;
import swim.linker.AuthDef;
import swim.linker.PlaneDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class PlaneForm
extends Form<PlaneDef> {
    PlaneForm() {
    }

    public String tag() {
        return "plane";
    }

    public Class<?> type() {
        return PlaneDef.class;
    }

    public Item mold(PlaneDef planeDef) {
        if (planeDef != null) {
            Record record = Record.create().attr(this.tag(), planeDef.name);
            if (planeDef.className != null) {
                record.slot("class", planeDef.className);
            }
            for (AgentTypeDef agentTypeDef : planeDef.agentTypeDefs.values()) {
                record.item((Item)agentTypeDef.toValue());
            }
            for (AuthDef authDef : planeDef.authDefs) {
                record.item((Item)authDef.toValue());
            }
            record.addAll((Collection)((Record)planeDef.warpSettings.toValue()));
            return record;
        }
        return Item.extant();
    }

    public PlaneDef cast(Item value) {
        String name = value.getAttr(this.tag()).stringValue(null);
        if (name != null) {
            String className = value.get("class").stringValue(null);
            HashTrieMap agentTypeDefs = HashTrieMap.empty();
            FingerTrieSeq authDefs = FingerTrieSeq.empty();
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Value item = value.getItem(i).toValue();
                AgentTypeDef agentTypeDef = (AgentTypeDef)AgentTypeDef.form().cast((Item)item);
                if (agentTypeDef != null) {
                    agentTypeDefs = agentTypeDefs.updated((Object)agentTypeDef.name(), (Object)agentTypeDef);
                    continue;
                }
                AuthDef authDef = (AuthDef)AuthDef.authForm().cast((Item)item);
                if (authDef == null) continue;
                authDefs = authDefs.appended((Object)authDef);
            }
            WarpSettings warpSettings = (WarpSettings)WarpSettings.form().cast(value);
            if (warpSettings.tlsSettings() == null) {
                warpSettings = warpSettings.tlsSettings(TlsSettings.standard());
            }
            return new PlaneDef(name, className, (HashTrieMap<String, AgentTypeDef>)agentTypeDefs, (FingerTrieSeq<AuthDef>)authDefs, warpSettings, (Record)value);
        }
        return null;
    }
}

