/*
 * Decompiled with CFR 0.152.
 */
package swim.linker;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.HashTrieMap;
import swim.linker.PlaneDef;
import swim.linker.ServerForm;
import swim.linker.ServiceDef;
import swim.linker.StoreDef;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Murmur3;

public final class ServerDef
implements Debug {
    final HashTrieMap<String, PlaneDef> planeDefs;
    final HashTrieMap<Uri, ServiceDef> serviceDefs;
    final StoreDef storeDef;
    private static int hashSeed;
    private static Form<ServerDef> form;

    public ServerDef(HashTrieMap<String, PlaneDef> planeDefs, HashTrieMap<Uri, ServiceDef> serviceDefs, StoreDef storeDef) {
        this.planeDefs = planeDefs;
        this.serviceDefs = serviceDefs;
        this.storeDef = storeDef;
    }

    public HashTrieMap<String, PlaneDef> planeDefs() {
        return this.planeDefs;
    }

    public PlaneDef getPlaneDef(String planeName) {
        return (PlaneDef)this.planeDefs.get((Object)planeName);
    }

    public ServerDef planeDef(PlaneDef planeDef) {
        return new ServerDef((HashTrieMap<String, PlaneDef>)this.planeDefs.updated((Object)planeDef.name(), (Object)planeDef), this.serviceDefs, this.storeDef);
    }

    public HashTrieMap<Uri, ServiceDef> serviceDefs() {
        return this.serviceDefs;
    }

    public ServiceDef getServiceDef(Uri serviceUri) {
        return (ServiceDef)this.serviceDefs.get((Object)serviceUri);
    }

    public ServerDef serviceDef(ServiceDef serviceDef) {
        return new ServerDef(this.planeDefs, (HashTrieMap<Uri, ServiceDef>)this.serviceDefs.updated((Object)serviceDef.uri(), (Object)serviceDef), this.storeDef);
    }

    public StoreDef storeDef() {
        return this.storeDef;
    }

    public ServerDef storeDef(StoreDef storeDef) {
        return new ServerDef(this.planeDefs, this.serviceDefs, this.storeDef);
    }

    public Value toValue() {
        return ServerDef.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ServerDef) {
            ServerDef that = (ServerDef)other;
            return this.planeDefs.equals(that.planeDefs) && this.serviceDefs.equals(that.serviceDefs) && this.storeDef.equals(that.storeDef);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ServerDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.planeDefs.hashCode()), (int)this.serviceDefs.hashCode()), (int)this.storeDef.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("new").write(32).write("ServerDef").write(40).debug(this.planeDefs).write(", ").debug(this.serviceDefs).write(", ").debug((Object)this.storeDef).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    @Kind
    public static Form<ServerDef> form() {
        if (form == null) {
            form = new ServerForm();
        }
        return form;
    }
}

