/*
 * Decompiled with CFR 0.152.
 */
package swim.linker;

import swim.api.auth.Authenticated;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.policy.PolicyDirective;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.FingerTrieSeq;
import swim.linker.AuthDef;
import swim.linker.OpenIdAuthForm;
import swim.security.JsonWebSignature;
import swim.security.OpenIdToken;
import swim.security.PublicKeyDef;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Murmur3;

public final class OpenIdAuthDef
extends AuthDef
implements Debug {
    final FingerTrieSeq<String> issuers;
    final FingerTrieSeq<String> audiences;
    final FingerTrieSeq<PublicKeyDef> publicKeyDefs;
    private static int hashSeed;
    private static Form<OpenIdAuthDef> form;

    public OpenIdAuthDef(FingerTrieSeq<String> issuers, FingerTrieSeq<String> audiences, FingerTrieSeq<PublicKeyDef> publicKeyDefs) {
        this.issuers = issuers;
        this.audiences = audiences;
        this.publicKeyDefs = publicKeyDefs;
    }

    public FingerTrieSeq<String> issuers() {
        return this.issuers;
    }

    public FingerTrieSeq<String> audiences() {
        return this.audiences;
    }

    public FingerTrieSeq<PublicKeyDef> publicKeyDefs() {
        return this.publicKeyDefs;
    }

    public PolicyDirective<Identity> authenticate(Uri requestUri, Uri fromUri, JsonWebSignature jws) {
        Value payloadValue = jws.payload();
        if (payloadValue.isDefined()) {
            OpenIdToken idToken = new OpenIdToken(payloadValue);
            int n = this.publicKeyDefs.size();
            for (int i = 0; i < n; ++i) {
                if (!jws.verifySignature(((PublicKeyDef)this.publicKeyDefs.get(i)).publicKey())) continue;
                return PolicyDirective.allow((Object)new Authenticated(requestUri, fromUri, idToken.toValue()));
            }
        }
        return null;
    }

    @Override
    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        JsonWebSignature jws;
        String compactJws = credentials.claims().get("idToken").stringValue(null);
        if (compactJws == null) {
            compactJws = credentials.claims().get("openIdToken").stringValue(null);
        }
        if (compactJws != null && (jws = JsonWebSignature.parse((String)compactJws)) != null) {
            return this.authenticate(credentials.requestUri(), credentials.fromUri(), jws);
        }
        return null;
    }

    @Override
    public Value toValue() {
        return OpenIdAuthDef.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof OpenIdAuthDef) {
            OpenIdAuthDef that = (OpenIdAuthDef)other;
            return this.issuers.equals(that.issuers) && this.audiences.equals(that.audiences) && this.publicKeyDefs.equals(that.publicKeyDefs);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(OpenIdAuthDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.issuers.hashCode()), (int)this.audiences.hashCode()), (int)this.publicKeyDefs.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("new").write(32).write("OpenIdAuthDef").write(40).debug(this.issuers).write(", ").debug(this.audiences).write(", ").debug(this.publicKeyDefs).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    @Kind
    public static Form<OpenIdAuthDef> form() {
        if (form == null) {
            form = new OpenIdAuthForm();
        }
        return form;
    }
}

