/*
 * Decompiled with CFR 0.152.
 */
package swim.linker;

import swim.collections.HashTrieMap;
import swim.linker.HttpServiceDef;
import swim.linker.HttpsServiceDef;
import swim.linker.PlaneDef;
import swim.linker.ServerDef;
import swim.linker.ServiceDef;
import swim.linker.StoreDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

final class ServerForm
extends Form<ServerDef> {
    ServerForm() {
    }

    public String tag() {
        return "server";
    }

    public Class<?> type() {
        return ServerDef.class;
    }

    public Item mold(ServerDef serverDef) {
        if (serverDef != null) {
            Record record = Record.create().attr(this.tag());
            for (PlaneDef planeDef : serverDef.planeDefs.values()) {
                record.add((Item)planeDef.toValue());
            }
            for (ServiceDef serviceDef : serverDef.serviceDefs.values()) {
                record.add((Item)serviceDef.toValue());
            }
            record.add((Item)serverDef.storeDef.toValue());
            return record;
        }
        return Item.extant();
    }

    public ServerDef cast(Item item) {
        Value value = item.toValue();
        Value header = value.getAttr(this.tag());
        if (header.isDefined()) {
            HashTrieMap planeDefs = HashTrieMap.empty();
            HashTrieMap serviceDefs = HashTrieMap.empty();
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                StoreDef newStoreDef;
                HttpsServiceDef httpsServiceDef;
                HttpServiceDef httpServiceDef;
                Item member = value.getItem(i);
                PlaneDef planeDef = (PlaneDef)PlaneDef.form().cast(member);
                if (planeDef != null) {
                    planeDefs = planeDefs.updated((Object)planeDef.name(), (Object)planeDef);
                }
                if ((httpServiceDef = (HttpServiceDef)HttpServiceDef.form().cast(member)) != null) {
                    serviceDefs = serviceDefs.updated((Object)httpServiceDef.uri(), (Object)httpServiceDef);
                }
                if ((httpsServiceDef = (HttpsServiceDef)HttpsServiceDef.form().cast(member)) != null) {
                    serviceDefs = serviceDefs.updated((Object)httpsServiceDef.uri(), (Object)httpsServiceDef);
                }
                if ((newStoreDef = (StoreDef)StoreDef.form().cast(member)) == null) continue;
                storeDef = newStoreDef;
            }
            if (storeDef == null) {
                storeDef = new StoreDef(null);
            }
            return new ServerDef((HashTrieMap<String, PlaneDef>)planeDefs, (HashTrieMap<Uri, ServiceDef>)serviceDefs, storeDef);
        }
        return null;
    }
}

