/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.BoxR2;
import swim.math.CircleR2;
import swim.math.PointR2;
import swim.math.R2Form;
import swim.math.R2Shape;
import swim.structure.Item;
import swim.structure.Value;

final class R2ShapeForm
extends R2Form<R2Shape> {
    R2ShapeForm() {
    }

    public Class<?> type() {
        return R2Shape.class;
    }

    @Override
    public double getXMin(R2Shape shape) {
        return shape.xMin();
    }

    @Override
    public double getYMin(R2Shape shape) {
        return shape.yMin();
    }

    @Override
    public double getXMax(R2Shape shape) {
        return shape.xMax();
    }

    @Override
    public double getYMax(R2Shape shape) {
        return shape.yMax();
    }

    @Override
    public boolean contains(R2Shape outer, R2Shape inner) {
        return outer.contains(inner);
    }

    @Override
    public boolean intersects(R2Shape s, R2Shape t) {
        return s.intersects(t);
    }

    public Item mold(R2Shape shape) {
        if (shape != null) {
            return shape.toValue();
        }
        return Item.extant();
    }

    public R2Shape cast(Item item) {
        Value value = item.toValue();
        String tag = value.tag();
        if ("point".equals(tag)) {
            return (R2Shape)PointR2.form().cast((Item)value);
        }
        if ("box".equals(tag)) {
            return (R2Shape)BoxR2.form().cast((Item)value);
        }
        if ("circle".equals(tag)) {
            return (R2Shape)CircleR2.form().cast((Item)value);
        }
        return null;
    }
}

