/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.TensorDims;
import swim.structure.Attr;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;

final class TensorDimsForm
extends Form<TensorDims> {
    TensorDimsForm() {
    }

    public String tag() {
        return "dim";
    }

    public TensorDims unit() {
        return TensorDims.undefined();
    }

    public Class<?> type() {
        return TensorDims.class;
    }

    public Item mold(TensorDims dim) {
        Record record = Record.create((int)dim.rank());
        do {
            Record header = Record.create((int)2);
            header.slot("size", dim.size);
            if (!dim.isPacked()) {
                header.slot("stride", dim.stride);
            }
            record.attr(this.tag(), (Value)header);
        } while ((dim = dim.next) != null);
        return record;
    }

    public TensorDims cast(Item item) {
        Value value = item.toValue();
        TensorDims next = null;
        for (int i = value.length() - 1; i >= 0; --i) {
            Value header;
            Value size;
            Item member = value.getItem(i);
            if (!(member instanceof Attr) || !this.tag().equals(member.key().stringValue(null)) || !((size = (header = member.toValue()).get("size")) instanceof Num)) continue;
            Value stride = header.get("stride");
            if (stride instanceof Num) {
                if (next != null) {
                    next = next.by(size.intValue(), stride.intValue());
                    continue;
                }
                next = TensorDims.of(size.intValue(), stride.intValue());
                continue;
            }
            next = next != null ? next.by(size.intValue()) : TensorDims.of(size.intValue());
        }
        return next;
    }
}

