/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.R;
import swim.math.Tensor;
import swim.math.TensorDims;
import swim.math.TensorForm;
import swim.math.TensorSpace;

final class TensorObjectSpace
implements TensorSpace<Tensor, Double>,
Debug {
    final TensorSpace<Tensor, Double> next;
    final TensorDims dims;

    TensorObjectSpace(TensorSpace<Tensor, Double> next, TensorDims dims) {
        this.next = next;
        this.dims = dims;
    }

    TensorObjectSpace(TensorSpace<Tensor, Double> next, int n) {
        this(next, next.dimensions().by(n));
    }

    public R scalar() {
        return R.field();
    }

    @Override
    public TensorDims dimensions() {
        return this.dims;
    }

    public TensorForm<Tensor> form() {
        return Tensor.form(this.dims);
    }

    @Override
    public Tensor zero() {
        return Tensor.zero(this.dims);
    }

    public Tensor of(double ... array) {
        return new Tensor(this.dims, array);
    }

    public Tensor of(float ... array) {
        return new Tensor(this.dims, array);
    }

    @Override
    public Tensor add(Tensor u, Tensor v) {
        return u.plus(v);
    }

    @Override
    public Tensor opposite(Tensor v) {
        return v.opposite();
    }

    @Override
    public Tensor subtract(Tensor u, Tensor v) {
        return u.minus(v);
    }

    @Override
    public Tensor multiply(Tensor u, Double a) {
        return u.times(a);
    }

    @Override
    public Tensor combine(Double a, Tensor u, Double b, Tensor v) {
        return Tensor.combine(a, u, b, v);
    }

    public void debug(Output<?> output) {
        output.write("Tensor").write(46).write("space").write(40).debug(this.next).write(", ").debug((Object)this.dims).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

