/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.DimensionException;
import swim.math.TensorForm;
import swim.math.VectorRNForm;
import swim.structure.Kind;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Murmur3;

public class VectorRN
implements Debug {
    final double[] array;
    private static int hashSeed;
    private static TensorForm<VectorRN> form;

    public VectorRN(double ... array) {
        this.array = array;
    }

    public final int dimension() {
        return this.array.length;
    }

    public final double get(int i) {
        return this.array[i];
    }

    public final VectorRN plus(VectorRN that) {
        double[] us = this.array;
        int n = us.length;
        double[] vs = that.array;
        if (n != vs.length) {
            throw new DimensionException();
        }
        double[] ws = new double[n];
        for (int i = 0; i < n; ++i) {
            ws[i] = us[i] + vs[i];
        }
        return new VectorRN(ws);
    }

    public final VectorRN opposite() {
        double[] us = this.array;
        int n = us.length;
        double[] ws = new double[n];
        for (int i = 0; i < n; ++i) {
            ws[i] = -us[i];
        }
        return new VectorRN(ws);
    }

    public final VectorRN minus(VectorRN that) {
        double[] us = this.array;
        int n = us.length;
        double[] vs = that.array;
        if (n != vs.length) {
            throw new DimensionException();
        }
        double[] ws = new double[n];
        for (int i = 0; i < n; ++i) {
            ws[i] = us[i] - vs[i];
        }
        return new VectorRN(ws);
    }

    public final VectorRN times(double scalar) {
        double[] us = this.array;
        int n = us.length;
        double[] ws = new double[n];
        for (int i = 0; i < n; ++i) {
            ws[i] = us[i] * scalar;
        }
        return new VectorRN(ws);
    }

    public Value toValue() {
        double[] us = this.array;
        int n = us.length;
        Record header = Record.create((int)n);
        for (int i = 0; i < n; ++i) {
            header.item(us[i]);
        }
        return Record.create((int)1).attr("vector", (Value)header);
    }

    protected boolean canEqual(VectorRN that) {
        return true;
    }

    public boolean equals(Object other) {
        double[] vs;
        double[] us;
        int n;
        VectorRN that;
        if (this == other) {
            return true;
        }
        if (other instanceof VectorRN && (that = (VectorRN)other).canEqual(this) && (n = (us = this.array).length) == (vs = that.array).length) {
            for (int i = 0; i < n; ++i) {
                if (us[i] == vs[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(VectorRN.class);
        }
        int code = hashSeed;
        double[] us = this.array;
        int n = us.length;
        for (int i = 0; i < n; ++i) {
            code = Murmur3.mix((int)code, (int)Murmur3.hash((double)us[i]));
        }
        return Murmur3.mash((int)code);
    }

    public void debug(Output<?> output) {
        output = output.write("VectorRN").write(46).write("of").write(40);
        double[] us = this.array;
        int n = us.length;
        if (n > 0) {
            output = output.debug((Object)us[0]);
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug((Object)us[i]);
            }
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static VectorRN of(double ... array) {
        return new VectorRN(array);
    }

    @Kind
    public static TensorForm<VectorRN> form() {
        if (form == null) {
            form = new VectorRNForm();
        }
        return form;
    }
}

