/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.AffineSpace;
import swim.math.F2;
import swim.math.PointR2;
import swim.math.R;
import swim.math.TensorDims;
import swim.math.VectorR2;
import swim.math.VectorSpace;

public class R2
implements AffineSpace<PointR2, VectorR2, Double>,
VectorSpace<VectorR2, Double>,
F2<VectorR2, Double>,
Debug {
    private static R2 space;

    protected R2() {
    }

    public final R2 vector() {
        return this;
    }

    @Override
    public final R scalar() {
        return R.field();
    }

    @Override
    public TensorDims dimensions() {
        return TensorDims.d2();
    }

    @Override
    public final PointR2 origin() {
        return PointR2.origin();
    }

    @Override
    public final VectorR2 zero() {
        return VectorR2.zero();
    }

    @Override
    public final VectorR2 of(Double x, Double y) {
        return VectorR2.of(x, y);
    }

    @Override
    public final Double getX(VectorR2 v) {
        return v.x;
    }

    @Override
    public final Double getY(VectorR2 v) {
        return v.y;
    }

    @Override
    public final VectorR2 add(VectorR2 u, VectorR2 v) {
        return u.plus(v);
    }

    @Override
    public final VectorR2 opposite(VectorR2 v) {
        return v.opposite();
    }

    @Override
    public final VectorR2 subtract(VectorR2 u, VectorR2 v) {
        return u.minus(v);
    }

    @Override
    public final VectorR2 multiply(VectorR2 u, Double a) {
        return u.times(a);
    }

    @Override
    public final VectorR2 combine(Double a, VectorR2 u, Double b, VectorR2 v) {
        return new VectorR2(a * u.x + b * v.x, a * u.y + b * v.y);
    }

    @Override
    public final PointR2 translate(PointR2 p, VectorR2 v) {
        return p.plus(v);
    }

    @Override
    public final VectorR2 difference(PointR2 p, PointR2 q) {
        return p.minus(q);
    }

    public void debug(Output<?> output) {
        output.write("R2").write(46).write("space").write(40).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static R2 space() {
        if (space == null) {
            space = new R2();
        }
        return space;
    }
}

