/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.BoxR3;
import swim.math.BoxZ3;
import swim.math.PointR3;
import swim.math.R3Form;
import swim.math.R3Shape;
import swim.math.R3ToZ3Function;
import swim.math.SphereR3Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class SphereR3
extends R3Shape
implements Debug {
    public final double cx;
    public final double cy;
    public final double cz;
    public final double r;
    private static int hashSeed;
    private static R3Form<SphereR3> form;

    public SphereR3(double cx, double cy, double cz, double r) {
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        this.r = r;
    }

    @Override
    public final double xMin() {
        return this.cx - this.r;
    }

    @Override
    public final double yMin() {
        return this.cy - this.r;
    }

    @Override
    public final double zMin() {
        return this.cz - this.r;
    }

    @Override
    public final double xMax() {
        return this.cx + this.r;
    }

    @Override
    public final double yMax() {
        return this.cy + this.r;
    }

    @Override
    public final double zMax() {
        return this.cz + this.r;
    }

    @Override
    public boolean contains(R3Shape shape) {
        if (shape instanceof PointR3) {
            return this.contains((PointR3)shape);
        }
        if (shape instanceof BoxR3) {
            return this.contains((BoxR3)shape);
        }
        if (shape instanceof SphereR3) {
            return this.contains((SphereR3)shape);
        }
        return false;
    }

    public boolean contains(PointR3 point) {
        double dx = point.x - this.cx;
        double dy = point.y - this.cy;
        double dz = point.z - this.cz;
        return dx * dx + dy * dy + dz * dz <= this.r * this.r;
    }

    public boolean contains(BoxR3 box) {
        double dxMin = box.xMin - this.cx;
        double dyMin = box.yMin - this.cy;
        double dzMin = box.zMin - this.cz;
        double dxMax = box.xMax - this.cx;
        double dyMax = box.yMax - this.cy;
        double dzMax = box.zMax - this.cz;
        double r2 = this.r * this.r;
        return dxMin * dxMin + dyMin * dyMin + dzMin * dzMin <= r2 && dxMin * dxMin + dyMin * dyMin + dzMax * dzMax <= r2 && dxMin * dxMin + dyMax * dyMax + dzMin * dzMin <= r2 && dxMin * dxMin + dyMax * dyMax + dzMax * dzMax <= r2 && dxMax * dxMax + dyMin * dyMin + dzMin * dzMin <= r2 && dxMax * dxMax + dyMin * dyMin + dzMax * dzMax <= r2 && dxMax * dxMax + dyMax * dyMax + dzMin * dzMin <= r2 && dxMax * dxMax + dyMax * dyMax + dzMax * dzMax <= r2;
    }

    public boolean contains(SphereR3 sphere) {
        double dx = sphere.cx - this.cx;
        double dy = sphere.cy - this.cy;
        double dz = sphere.cz - this.cz;
        return dx * dx + dy * dy + dz * dz + sphere.r * sphere.r <= this.r * this.r;
    }

    @Override
    public boolean intersects(R3Shape shape) {
        if (shape instanceof PointR3) {
            return this.intersects((PointR3)shape);
        }
        if (shape instanceof BoxR3) {
            return this.intersects((BoxR3)shape);
        }
        if (shape instanceof SphereR3) {
            return this.intersects((SphereR3)shape);
        }
        return shape.intersects(this);
    }

    public boolean intersects(PointR3 point) {
        double dx = point.x - this.cx;
        double dy = point.y - this.cy;
        double dz = point.z - this.cz;
        return dx * dx + dy * dy + dz * dz <= this.r * this.r;
    }

    public boolean intersects(BoxR3 box) {
        double dx = (this.cx < box.xMin ? box.xMin : (box.xMax < this.cx ? box.xMax : this.cx)) - this.cx;
        double dy = (this.cy < box.yMin ? box.yMin : (box.yMax < this.cy ? box.yMax : this.cy)) - this.cy;
        double dz = (this.cz < box.zMin ? box.zMin : (box.zMax < this.cz ? box.xMax : this.cz)) - this.cz;
        return dx * dx + dy * dy + dz * dz <= this.r * this.r;
    }

    public boolean intersects(SphereR3 sphere) {
        double dx = sphere.cx - this.cx;
        double dy = sphere.cy - this.cy;
        double dz = sphere.cz - this.cz;
        double rr = this.r + sphere.r;
        return dx * dx + dy * dy + dz * dz <= rr * rr;
    }

    @Override
    public BoxZ3 transform(R3ToZ3Function f) {
        double xMin = this.cx - this.r;
        double yMin = this.cy - this.r;
        double zMin = this.cz - this.r;
        double xMax = this.cx + this.r;
        double yMax = this.cy + this.r;
        double zMax = this.cz + this.r;
        return new BoxZ3(f.transformX(xMin, yMin, zMin), f.transformY(xMin, yMin, zMin), f.transformZ(xMin, yMin, zMin), f.transformX(xMax, yMax, xMax), f.transformY(xMax, yMax, xMax), f.transformZ(xMax, yMax, xMax));
    }

    @Override
    public Value toValue() {
        return SphereR3.form().mold(this).toValue();
    }

    protected boolean canEqual(SphereR3 that) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SphereR3) {
            SphereR3 that = (SphereR3)other;
            return that.canEqual(this) && this.cx == that.cx && this.cy == that.cy && this.cz == that.cz && this.r == that.r;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(SphereR3.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((double)this.cx)), (int)Murmur3.hash((double)this.cy)), (int)Murmur3.hash((double)this.cz)), (int)Murmur3.hash((double)this.r)));
    }

    public void debug(Output<?> output) {
        output.write("SphereR3").write(46).write("of").write(40).debug((Object)this.cx).write(", ").debug((Object)this.cy).write(", ").debug((Object)this.cz).write(", ").debug((Object)this.r).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static SphereR3 of(double cx, double cy, double cz, double r) {
        return new SphereR3(cx, cy, cz, r);
    }

    @Kind
    public static R3Form<SphereR3> form() {
        if (form == null) {
            form = new SphereR3Form();
        }
        return form;
    }
}

