/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.TensorArrayObjectSpace;
import swim.math.TensorArraySpace;
import swim.math.TensorDims;
import swim.math.TensorSpace;
import swim.util.Murmur3;

public class TensorArray<V, S>
implements Debug {
    final TensorSpace<TensorArray<V, S>, S> space;
    final Object[] array;
    private static int hashSeed;

    public TensorArray(TensorSpace<TensorArray<V, S>, S> space, Object ... array) {
        this.space = space;
        this.array = array;
    }

    public final TensorSpace<TensorArray<V, S>, S> space() {
        return this.space;
    }

    public final TensorDims dimensions() {
        return this.space.dimensions();
    }

    public final V get(int i) {
        return (V)this.array[i];
    }

    public TensorArray<V, S> plus(TensorArray<V, S> that) {
        return this.space.add(this, that);
    }

    public TensorArray<V, S> opposite() {
        return this.space.opposite(this);
    }

    public TensorArray<V, S> minus(TensorArray<V, S> that) {
        return this.space.subtract(this, that);
    }

    public TensorArray<V, S> times(S scalar) {
        return this.space.multiply(this, scalar);
    }

    protected boolean canEqual(TensorArray<?, ?> that) {
        return true;
    }

    public boolean equals(Object other) {
        Object[] vs;
        Object[] us;
        int n;
        TensorArray that;
        if (this == other) {
            return true;
        }
        if (other instanceof TensorArray && (that = (TensorArray)other).canEqual(this) && (n = (us = this.array).length) == (vs = that.array).length) {
            for (int i = 0; i < n; ++i) {
                Object u = us[i];
                Object v = vs[i];
                if (!(u == null ? v != null : !u.equals(v))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(TensorArray.class);
        }
        int code = hashSeed;
        Object[] us = this.array;
        int n = us.length;
        for (int i = 0; i < n; ++i) {
            code = Murmur3.mix((int)code, (int)Murmur3.hash((Object)us[i]));
        }
        return Murmur3.mash((int)code);
    }

    public void debug(Output<?> output) {
        output = output.debug(this.space).write(46).write("fromArray").write(40);
        Object[] us = this.array;
        int n = us.length;
        if (n > 0) {
            output = output.debug(us[0]);
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(us[i]);
            }
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <V, S> TensorArraySpace<TensorArray<V, S>, V, S> space(TensorSpace<V, S> next, TensorDims dims) {
        return new TensorArrayObjectSpace<V, S>(next, dims);
    }

    public static <V, S> TensorArraySpace<TensorArray<V, S>, V, S> space(TensorSpace<V, S> next, int n) {
        return new TensorArrayObjectSpace<V, S>(next, next.dimensions().by(n));
    }
}

