/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.R3ToZ3Function;
import swim.math.TensorForm;
import swim.math.VectorR3Form;
import swim.math.VectorZ3;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class VectorR3
implements Debug {
    public final double x;
    public final double y;
    public final double z;
    private static int hashSeed;
    private static VectorR3 zero;
    private static TensorForm<VectorR3> form;

    public VectorR3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final VectorR3 plus(VectorR3 that) {
        return new VectorR3(this.x + that.x, this.y + that.y, this.z + that.z);
    }

    public final VectorR3 opposite() {
        return new VectorR3(-this.x, -this.y, -this.z);
    }

    public final VectorR3 minus(VectorR3 that) {
        return new VectorR3(this.x - that.x, this.y - that.y, this.z - that.z);
    }

    public final VectorR3 times(double scalar) {
        return new VectorR3(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public VectorZ3 transform(R3ToZ3Function f) {
        return new VectorZ3(f.transformX(this.x, this.y, this.z), f.transformY(this.x, this.y, this.z), f.transformZ(this.x, this.y, this.z));
    }

    public Value toValue() {
        return VectorR3.form().mold(this).toValue();
    }

    protected boolean canEqual(VectorR3 that) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof VectorR3) {
            VectorR3 that = (VectorR3)other;
            return that.canEqual(this) && this.x == that.x && this.y == that.y && this.z == that.z;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(VectorR3.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((double)this.x)), (int)Murmur3.hash((double)this.y)), (int)Murmur3.hash((double)this.z)));
    }

    public void debug(Output<?> output) {
        output.write("VectorR3").write(46).write("of").write(40).debug((Object)this.x).write(", ").debug((Object)this.y).write(", ").debug((Object)this.z).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static VectorR3 zero() {
        if (zero == null) {
            zero = new VectorR3(0.0, 0.0, 0.0);
        }
        return zero;
    }

    public static VectorR3 of(double x, double y, double z) {
        return new VectorR3(x, y, z);
    }

    @Kind
    public static TensorForm<VectorR3> form() {
        if (form == null) {
            form = new VectorR3Form();
        }
        return form;
    }
}

