/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.PointR3;
import swim.math.PointZ3Form;
import swim.math.VectorZ3;
import swim.math.Z3Form;
import swim.math.Z3Shape;
import swim.math.Z3ToR3Function;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class PointZ3
extends Z3Shape
implements Debug {
    public final long x;
    public final long y;
    public final long z;
    private static int hashSeed;
    private static PointZ3 origin;
    private static Z3Form<PointZ3> form;

    public PointZ3(long x, long y, long z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final PointZ3 plus(VectorZ3 vector) {
        return new PointZ3(this.x + vector.x, this.y + vector.y, this.z + vector.z);
    }

    public final PointZ3 minux(VectorZ3 vector) {
        return new PointZ3(this.x - vector.x, this.y - vector.y, this.z - vector.z);
    }

    public final VectorZ3 minus(PointZ3 that) {
        return new VectorZ3(this.x - that.x, this.y - that.y, this.z - that.z);
    }

    @Override
    public final long xMin() {
        return this.x;
    }

    @Override
    public final long yMin() {
        return this.y;
    }

    @Override
    public final long zMin() {
        return this.z;
    }

    @Override
    public final long xMax() {
        return this.x;
    }

    @Override
    public final long yMax() {
        return this.y;
    }

    @Override
    public final long zMax() {
        return this.z;
    }

    @Override
    public boolean contains(Z3Shape shape) {
        return this.x <= shape.xMin() && shape.xMax() <= this.x && this.y <= shape.yMin() && shape.yMax() <= this.y && this.z <= shape.zMin() && shape.zMax() <= this.z;
    }

    @Override
    public boolean intersects(Z3Shape shape) {
        return shape.intersects(this);
    }

    @Override
    public PointR3 transform(Z3ToR3Function f) {
        return new PointR3(f.transformX(this.x, this.y, this.z), f.transformY(this.x, this.y, this.z), f.transformZ(this.x, this.y, this.z));
    }

    @Override
    public Value toValue() {
        return PointZ3.form().mold(this).toValue();
    }

    protected boolean canEqual(PointZ3 that) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PointZ3) {
            PointZ3 that = (PointZ3)other;
            return that.canEqual(this) && this.x == that.x && this.y == that.y && this.z == that.z;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(PointZ3.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((long)this.x)), (int)Murmur3.hash((long)this.y)), (int)Murmur3.hash((long)this.z)));
    }

    public void debug(Output<?> output) {
        output.write("PointZ3").write(46).write("of").write(40).debug((Object)this.x).write(", ").debug((Object)this.y).write(", ").debug((Object)this.z).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static PointZ3 origin() {
        if (origin == null) {
            origin = new PointZ3(0L, 0L, 0L);
        }
        return origin;
    }

    public static PointZ3 of(long x, long y, long z) {
        return new PointZ3(x, y, z);
    }

    @Kind
    public static Z3Form<PointZ3> form() {
        if (form == null) {
            form = new PointZ3Form();
        }
        return form;
    }
}

