/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.Distribution;
import swim.math.Random;

public class UniformDistribution
extends Distribution {
    final Random random;
    final double lower;
    final double upper;

    public UniformDistribution(Random random, double lower, double upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException(lower + " >= " + upper);
        }
        this.random = random;
        this.lower = lower;
        this.upper = upper;
    }

    public UniformDistribution(double lower, double upper) {
        this(Random.get(), lower, upper);
    }

    @Override
    public double density(double x) {
        if (this.lower <= x && x <= this.upper) {
            return 1.0 / (this.upper - this.lower);
        }
        return 0.0;
    }

    @Override
    public double sample() {
        double u = this.random.nextDouble();
        return u * this.upper + (1.0 - u) * this.lower;
    }
}

