/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.F3;
import swim.math.VectorZ3;
import swim.math.Z;

public class Z3
implements F3<VectorZ3, Long>,
Debug {
    private static Z3 module;

    protected Z3() {
    }

    public final Z scalar() {
        return Z.ring();
    }

    @Override
    public final VectorZ3 zero() {
        return VectorZ3.zero();
    }

    @Override
    public final VectorZ3 of(Long x, Long y, Long z) {
        return VectorZ3.of(x, y, z);
    }

    @Override
    public final Long getX(VectorZ3 v) {
        return v.x;
    }

    @Override
    public final Long getY(VectorZ3 v) {
        return v.y;
    }

    @Override
    public final Long getZ(VectorZ3 v) {
        return v.z;
    }

    @Override
    public final VectorZ3 add(VectorZ3 u, VectorZ3 v) {
        return u.plus(v);
    }

    @Override
    public final VectorZ3 opposite(VectorZ3 v) {
        return v.opposite();
    }

    @Override
    public final VectorZ3 subtract(VectorZ3 u, VectorZ3 v) {
        return u.minus(v);
    }

    @Override
    public final VectorZ3 multiply(VectorZ3 u, Long a) {
        return u.times(a);
    }

    @Override
    public final VectorZ3 combine(Long a, VectorZ3 u, Long b, VectorZ3 v) {
        return new VectorZ3(a * u.x + b * v.x, a * u.y + b * v.y, a * u.z + b * v.z);
    }

    public void debug(Output<?> output) {
        output.write("Z3").write(46).write("module").write(40).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static Z3 module() {
        if (module == null) {
            module = new Z3();
        }
        return module;
    }
}

