/*
 * Decompiled with CFR 0.152.
 */
package swim.protobuf;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.protobuf.ProtobufDecoder;
import swim.protobuf.WireType;
import swim.util.Builder;

final class PackedDecoder<I, V>
extends Decoder<V> {
    final ProtobufDecoder<I, V> protobuf;
    final WireType wireType;
    final Decoder<V> valueDecoder;
    final Builder<I, V> builder;

    PackedDecoder(ProtobufDecoder<I, V> protobuf, WireType wireType, Decoder<V> valueDecoder, Builder<I, V> builder) {
        this.protobuf = protobuf;
        this.wireType = wireType;
        this.valueDecoder = valueDecoder;
        this.builder = builder;
    }

    public Decoder<V> feed(InputBuffer input) {
        return PackedDecoder.decode(input, this.protobuf, this.wireType, this.valueDecoder, this.builder);
    }

    static <I, V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<I, V> protobuf, WireType wireType, Decoder<V> valueDecoder, Builder<I, V> builder) {
        while (input.isCont()) {
            if ((valueDecoder = valueDecoder == null ? protobuf.decodeValue(wireType, input) : valueDecoder.feed(input)).isDone()) {
                if (builder == null) {
                    builder = protobuf.messageBuilder();
                }
                builder.add(protobuf.item(valueDecoder.bind()));
                valueDecoder = null;
                continue;
            }
            if (!valueDecoder.isError()) continue;
            return valueDecoder.asError();
        }
        if (input.isDone()) {
            if (valueDecoder == null) {
                if (builder == null) {
                    builder = protobuf.messageBuilder();
                }
                return PackedDecoder.done((Object)builder.bind());
            }
            return PackedDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        return new PackedDecoder<I, V>(protobuf, wireType, valueDecoder, builder);
    }

    static <I, V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<I, V> protobuf, WireType wireType) {
        return PackedDecoder.decode(input, protobuf, wireType, null, null);
    }
}

