/*
 * Decompiled with CFR 0.152.
 */
package swim.protobuf;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.protobuf.ProtobufDecoder;

final class VarintDecoder<V>
extends Decoder<V> {
    final ProtobufDecoder<?, V> protobuf;
    final boolean signed;
    final long value;
    final int shift;

    VarintDecoder(ProtobufDecoder<?, V> protobuf, boolean signed, long value, int shift) {
        this.protobuf = protobuf;
        this.value = value;
        this.shift = shift;
        this.signed = signed;
    }

    public Decoder<V> feed(InputBuffer input) {
        return VarintDecoder.decode(input, this.protobuf, this.signed, this.value, this.shift);
    }

    static <V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<?, V> protobuf, boolean signed, long value, int shift) {
        while (input.isCont()) {
            int b = input.head();
            if (shift < 64) {
                input = input.step();
                value |= (long)(b & 0x7F) << shift;
            } else {
                return VarintDecoder.error((Throwable)new DecoderException("varint overflow"));
            }
            if ((b & 0x80) == 0) {
                if (signed) {
                    value = value >>> 1 ^ value << 63 >> 63;
                    return VarintDecoder.done(protobuf.sint(value));
                }
                return VarintDecoder.done(protobuf.uint(value));
            }
            shift += 7;
        }
        if (input.isDone()) {
            return VarintDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return VarintDecoder.error((Throwable)input.trap());
        }
        return new VarintDecoder<V>(protobuf, signed, value, shift);
    }

    static <V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<?, V> protobuf) {
        return VarintDecoder.decode(input, protobuf, false, 0L, 0);
    }

    static <V> Decoder<V> decodeSigned(InputBuffer input, ProtobufDecoder<?, V> protobuf) {
        return VarintDecoder.decode(input, protobuf, true, 0L, 0);
    }
}

