/*
 * Decompiled with CFR 0.152.
 */
package swim.protobuf;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.protobuf.ProtobufDecoder;

final class Fixed32Decoder<V>
extends Decoder<V> {
    final ProtobufDecoder<?, V> protobuf;
    final int value;
    final int shift;

    Fixed32Decoder(ProtobufDecoder<?, V> protobuf, int value, int shift) {
        this.protobuf = protobuf;
        this.value = value;
        this.shift = shift;
    }

    public Decoder<V> feed(InputBuffer input) {
        return Fixed32Decoder.decode(input, this.protobuf, this.value, this.shift);
    }

    static <V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<?, V> protobuf, int value, int shift) {
        while (input.isCont()) {
            value |= input.head() << shift;
            input = input.step();
            if (shift != 0) {
                shift -= 8;
                continue;
            }
            return Fixed32Decoder.done(protobuf.fixed(value));
        }
        if (input.isDone()) {
            return Fixed32Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Fixed32Decoder.error((Throwable)input.trap());
        }
        return new Fixed32Decoder<V>(protobuf, value, shift);
    }

    static <V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<?, V> protobuf) {
        return Fixed32Decoder.decode(input, protobuf, 0, 24);
    }
}

