/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.recon.Recon;
import swim.recon.ReconParser;

final class IdentParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Output<V> output;
    final int step;

    IdentParser(ReconParser<I, V> recon, Output<V> output, int step) {
        this.recon = recon;
        this.output = output;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return IdentParser.parse(input, this.recon, this.output, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Output<V> output, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Recon.isIdentStartChar(c)) return IdentParser.error((Diagnostic)Diagnostic.expected((String)"identifier", (Input)input));
                input = input.step();
                if (output == null) {
                    output = recon.textOutput();
                }
                output = output.write(c);
                step = 2;
            } else if (input.isDone()) {
                return IdentParser.error((Diagnostic)Diagnostic.expected((String)"identifier", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Recon.isIdentChar(c = input.head())) {
                input = input.step();
                output = output.write(c);
            }
            if (!input.isEmpty()) {
                return IdentParser.done((Object)recon.ident(output.bind()));
            }
        }
        if (!input.isError()) return new IdentParser<I, Object>(recon, output, step);
        return IdentParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Output<V> output) {
        return IdentParser.parse(input, recon, output, 1);
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon) {
        return IdentParser.parse(input, recon, null, 1);
    }
}

