/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import java.math.BigInteger;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.recon.AdditiveOperatorParser;
import swim.recon.AndOperatorParser;
import swim.recon.AttrExpressionParser;
import swim.recon.AttrParser;
import swim.recon.BitwiseAndOperatorParser;
import swim.recon.BitwiseOrOperatorParser;
import swim.recon.BitwiseXorOperatorParser;
import swim.recon.BlockItemParser;
import swim.recon.BlockParser;
import swim.recon.ComparisonOperatorParser;
import swim.recon.ConditionalOperatorParser;
import swim.recon.DataParser;
import swim.recon.IdentParser;
import swim.recon.InlineItemParser;
import swim.recon.InvokeOperatorParser;
import swim.recon.LambdaFuncParser;
import swim.recon.LiteralParser;
import swim.recon.MarkupParser;
import swim.recon.MultiplicativeOperatorParser;
import swim.recon.NumberParser;
import swim.recon.OrOperatorParser;
import swim.recon.PrefixOperatorParser;
import swim.recon.PrimaryParser;
import swim.recon.Recon;
import swim.recon.RecordParser;
import swim.recon.SelectorParser;
import swim.recon.StringParser;
import swim.util.Builder;

public abstract class ReconParser<I, V> {
    public abstract boolean isDistinct(V var1);

    public abstract I item(V var1);

    public abstract V value(I var1);

    public abstract I attr(V var1, V var2);

    public abstract I attr(V var1);

    public abstract I slot(V var1, V var2);

    public abstract I slot(V var1);

    public abstract Builder<I, V> valueBuilder();

    public abstract Builder<I, V> recordBuilder();

    public abstract Output<V> dataOutput();

    public abstract Output<V> textOutput();

    public abstract V ident(V var1);

    public abstract V num(int var1);

    public abstract V num(long var1);

    public abstract V num(float var1);

    public abstract V num(double var1);

    public abstract V num(BigInteger var1);

    public abstract V num(String var1);

    public abstract V uint32(int var1);

    public abstract V uint64(long var1);

    public abstract V bool(boolean var1);

    public abstract V selector();

    public abstract V extant();

    public abstract V absent();

    public abstract V conditional(V var1, V var2, V var3);

    public abstract V or(V var1, V var2);

    public abstract V and(V var1, V var2);

    public abstract V bitwiseOr(V var1, V var2);

    public abstract V bitwiseXor(V var1, V var2);

    public abstract V bitwiseAnd(V var1, V var2);

    public abstract V lt(V var1, V var2);

    public abstract V le(V var1, V var2);

    public abstract V eq(V var1, V var2);

    public abstract V ne(V var1, V var2);

    public abstract V ge(V var1, V var2);

    public abstract V gt(V var1, V var2);

    public abstract V plus(V var1, V var2);

    public abstract V minus(V var1, V var2);

    public abstract V times(V var1, V var2);

    public abstract V divide(V var1, V var2);

    public abstract V modulo(V var1, V var2);

    public abstract V not(V var1);

    public abstract V bitwiseNot(V var1);

    public abstract V negative(V var1);

    public abstract V positive(V var1);

    public abstract V invoke(V var1, V var2);

    public abstract V lambda(V var1, V var2);

    public abstract V get(V var1, V var2);

    public abstract V getAttr(V var1, V var2);

    public abstract I getItem(V var1, V var2);

    public abstract V children(V var1);

    public abstract V descendants(V var1);

    public abstract V keys(V var1);

    public abstract V values(V var1);

    public abstract V filter(V var1, V var2);

    public Parser<V> parseBlock(Input input) {
        return BlockParser.parse(input, this);
    }

    public Parser<I> parseAttr(Input input) {
        return AttrParser.parse(input, this);
    }

    public Parser<V> parseBlockItem(Input input) {
        return BlockItemParser.parse(input, this);
    }

    public Parser<V> parseInlineItem(Input input) {
        return InlineItemParser.parse(input, this);
    }

    public Parser<V> parseRecord(Input input, Builder<I, V> builder) {
        return RecordParser.parse(input, this, builder);
    }

    public Parser<V> parseRecord(Input input) {
        return RecordParser.parse(input, this);
    }

    public Parser<V> parseMarkup(Input input, Builder<I, V> builder) {
        return MarkupParser.parse(input, this, builder);
    }

    public Parser<V> parseMarkup(Input input) {
        return MarkupParser.parse(input, this);
    }

    public Parser<V> parseData(Input input) {
        return DataParser.parse(input, this);
    }

    public Parser<V> parseIdent(Input input) {
        return IdentParser.parse(input, this);
    }

    public Parser<V> parseString(Input input) {
        return StringParser.parse(input, this);
    }

    public Parser<V> parseNumber(Input input) {
        return NumberParser.parse(input, this);
    }

    public Parser<V> parseInteger(Input input) {
        return NumberParser.parseInteger(input, this);
    }

    public Parser<V> parseBlockExpression(Input input, Builder<I, V> builder) {
        return this.parseLambdaFunc(input, builder);
    }

    public Parser<V> parseBlockExpression(Input input) {
        return this.parseLambdaFunc(input, null);
    }

    public Parser<V> parseLambdaFunc(Input input, Builder<I, V> builder) {
        return LambdaFuncParser.parse(input, this, builder);
    }

    public Parser<V> parseConditionalOperator(Input input, Builder<I, V> builder) {
        return ConditionalOperatorParser.parse(input, this, builder);
    }

    public Parser<V> parseOrOperator(Input input, Builder<I, V> builder) {
        return OrOperatorParser.parse(input, this, builder);
    }

    public Parser<V> parseAndOperator(Input input, Builder<I, V> builder) {
        return AndOperatorParser.parse(input, this, builder);
    }

    public Parser<V> parseBitwiseOrOperator(Input input, Builder<I, V> builder) {
        return BitwiseOrOperatorParser.parse(input, this, builder);
    }

    public Parser<V> parseBitwiseXorOperator(Input input, Builder<I, V> builder) {
        return BitwiseXorOperatorParser.parse(input, this, builder);
    }

    public Parser<V> parseBitwiseAndOperator(Input input, Builder<I, V> builder) {
        return BitwiseAndOperatorParser.parse(input, this, builder);
    }

    public Parser<V> parseComparisonOperator(Input input, Builder<I, V> builder) {
        return ComparisonOperatorParser.parse(input, this, builder);
    }

    public Parser<V> parseAttrExpression(Input input, Builder<I, V> builder) {
        return AttrExpressionParser.parse(input, this, builder);
    }

    public Parser<V> parseAdditiveOperator(Input input, Builder<I, V> builder) {
        return AdditiveOperatorParser.parse(input, this, builder);
    }

    public Parser<V> parseMultiplicativeOperator(Input input, Builder<I, V> builder) {
        return MultiplicativeOperatorParser.parse(input, this, builder);
    }

    public Parser<V> parsePrefixOperator(Input input, Builder<I, V> builder) {
        return PrefixOperatorParser.parse(input, this, builder);
    }

    public Parser<V> parseInvokeOperator(Input input, Builder<I, V> builder) {
        return InvokeOperatorParser.parse(input, this, builder);
    }

    public Parser<V> parsePrimary(Input input, Builder<I, V> builder) {
        return PrimaryParser.parse(input, this, builder);
    }

    public Parser<V> parseLiteral(Input input, Builder<I, V> builder) {
        return LiteralParser.parse(input, this, builder);
    }

    public Parser<V> parseSelector(Input input, Builder<I, V> builder) {
        return SelectorParser.parse(input, this, builder);
    }

    public Parser<V> parseSelector(Input input) {
        return SelectorParser.parse(input, this, null);
    }

    public Parser<V> blockParser() {
        return new BlockParser(this);
    }

    public V parseBlockString(String string) {
        Input input = Unicode.stringInput((String)string);
        while (input.isCont() && Recon.isWhitespace(input.head())) {
            input = input.step();
        }
        Parser parser = this.parseBlock(input);
        if (parser.isDone()) {
            while (input.isCont() && Recon.isWhitespace(input.head())) {
                input = input.step();
            }
        }
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (V)parser.bind();
    }

    public V parseNumberString(String string) {
        Input input = Unicode.stringInput((String)string);
        while (input.isCont() && Recon.isWhitespace(input.head())) {
            input = input.step();
        }
        Parser parser = this.parseNumber(input);
        if (parser.isDone()) {
            while (input.isCont() && Recon.isWhitespace(input.head())) {
                input = input.step();
            }
        }
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (V)parser.bind();
    }
}

