/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.ReconWriter;

final class SlotWriter<I, V>
extends Writer<Object, Object> {
    final ReconWriter<I, V> recon;
    final V key;
    final V value;
    final Writer<?, ?> part;
    final int step;

    SlotWriter(ReconWriter<I, V> recon, V key, V value, Writer<?, ?> part, int step) {
        this.recon = recon;
        this.key = key;
        this.value = value;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return SlotWriter.write(output, this.recon, this.key, this.value, this.part, this.step);
    }

    static <I, V> int sizeOf(ReconWriter<I, V> recon, V key, V value) {
        int size = 0;
        size += recon.sizeOfValue(key);
        ++size;
        if (!recon.isExtant(recon.item(value))) {
            size += recon.sizeOfValue(value);
        }
        return size;
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, V key, V value, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? recon.writeValue(key, output) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(58);
            if (recon.isExtant(recon.item(value))) {
                return SlotWriter.done();
            }
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? recon.writeValue(value, output) : part.pull(output)).isDone()) {
                return SlotWriter.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return SlotWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return SlotWriter.error((Throwable)output.trap());
        }
        return new SlotWriter<I, V>(recon, key, value, part, step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, V key, V value) {
        return SlotWriter.write(output, recon, key, value, null, 1);
    }
}

