/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.Recon;
import swim.recon.ReconParser;
import swim.util.Builder;

final class MultiplicativeOperatorParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Builder<I, V> builder;
    final Parser<V> lhsParser;
    final String operator;
    final Parser<V> rhsParser;
    final int step;

    MultiplicativeOperatorParser(ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> lhsParser, String operator, Parser<V> rhsParser, int step) {
        this.recon = recon;
        this.builder = builder;
        this.lhsParser = lhsParser;
        this.operator = operator;
        this.rhsParser = rhsParser;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return MultiplicativeOperatorParser.parse(input, this.recon, this.builder, this.lhsParser, this.operator, this.rhsParser, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> lhsParser, String operator, Parser<V> rhsParser, int step) {
        block23: {
            int c = 0;
            while (true) {
                if (step == 1) {
                    if (lhsParser == null) {
                        lhsParser = recon.parsePrefixOperator(input, builder);
                    }
                    while (lhsParser.isCont() && !input.isEmpty()) {
                        lhsParser = lhsParser.feed(input);
                    }
                    if (lhsParser.isDone()) {
                        step = 2;
                    } else if (lhsParser.isError()) {
                        return lhsParser.asError();
                    }
                }
                if (step == 2) {
                    while (input.isCont() && Recon.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        if (c == 42) {
                            input = input.step();
                            operator = "*";
                            step = 3;
                        } else if (c == 47) {
                            input = input.step();
                            operator = "/";
                            step = 3;
                        } else {
                            if (c != 37) return lhsParser;
                            input = input.step();
                            operator = "%";
                            step = 3;
                        }
                    } else if (input.isDone()) {
                        return lhsParser;
                    }
                }
                if (step != 3) break block23;
                if (rhsParser == null) {
                    rhsParser = recon.parsePrefixOperator(input, builder);
                }
                while (rhsParser.isCont() && !input.isEmpty()) {
                    rhsParser = rhsParser.feed(input);
                }
                if (!rhsParser.isDone()) break;
                Object lhs = lhsParser.bind();
                Object rhs = rhsParser.bind();
                if ("*".equals(operator)) {
                    lhsParser = MultiplicativeOperatorParser.done((Object)recon.times(lhs, rhs));
                } else if ("/".equals(operator)) {
                    lhsParser = MultiplicativeOperatorParser.done((Object)recon.divide(lhs, rhs));
                } else {
                    if (!"%".equals(operator)) return MultiplicativeOperatorParser.error((Diagnostic)Diagnostic.message((String)operator, (Input)input));
                    lhsParser = MultiplicativeOperatorParser.done((Object)recon.modulo(lhs, rhs));
                }
                rhsParser = null;
                operator = null;
                step = 2;
            }
            if (rhsParser.isError()) {
                return rhsParser.asError();
            }
        }
        if (!input.isError()) return new MultiplicativeOperatorParser<I, Object>(recon, builder, lhsParser, operator, rhsParser, step);
        return MultiplicativeOperatorParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder) {
        return MultiplicativeOperatorParser.parse(input, recon, builder, null, null, null, 1);
    }
}

