/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.downlink.DownlinkModel;
import swim.runtime.downlink.DownlinkView;

abstract class DownlinkRelay<Model extends DownlinkModel<View>, View extends DownlinkView>
implements Runnable {
    final Model model;
    final Object views;
    int viewIndex;
    final int viewCount;
    int phase;
    final int phaseCount;
    boolean preemptive;
    Stage stage;

    DownlinkRelay(Model model, int minPhase, int phaseCount) {
        this.model = model;
        this.views = ((DownlinkModel)model).views;
        this.viewCount = this.views instanceof DownlinkView ? 1 : (this.views instanceof DownlinkView[] ? ((DownlinkView[])this.views).length : 0);
        this.phase = minPhase;
        this.phaseCount = phaseCount;
        this.preemptive = true;
        this.beginPhase(this.phase);
    }

    DownlinkRelay(Model model, int phaseCount) {
        this(model, 0, phaseCount);
    }

    DownlinkRelay(Model model) {
        this(model, 0, 1);
    }

    boolean isDone() {
        return this.phase > this.phaseCount;
    }

    void beginPhase(int phase) {
    }

    boolean runPhase(View view, int phase, boolean preemptive) {
        return true;
    }

    void endPhase(int phase) {
    }

    void done() {
    }

    void pass(View view) {
        block6: {
            while (true) {
                if (this.viewIndex < this.viewCount) {
                    try {
                        if (!this.runPhase(view, this.phase, this.preemptive) && this.preemptive) {
                            this.preemptive = false;
                            if (this.stage == ((DownlinkView)view).stage) continue;
                            this.stage = ((DownlinkView)view).stage;
                            this.stage.execute((Runnable)this);
                            return;
                        }
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            ((DownlinkView)view).downlinkDidFail(error);
                        }
                        throw error;
                    }
                    ++this.viewIndex;
                    continue;
                }
                if (this.phase >= this.phaseCount) break block6;
                this.endPhase(this.phase);
                this.viewIndex = 0;
                ++this.phase;
                this.preemptive = true;
                if (this.phase >= this.phaseCount) break;
                this.beginPhase(this.phase);
            }
            this.endPhase(this.phase);
            ++this.phase;
            this.done();
            return;
        }
    }

    void pass(DownlinkView[] views) {
        block6: {
            while (true) {
                if (this.viewIndex < this.viewCount) {
                    DownlinkView view = views[this.viewIndex];
                    try {
                        if (!this.runPhase(view, this.phase, this.preemptive) && this.preemptive) {
                            this.preemptive = false;
                            if (this.stage == view.stage) continue;
                            this.stage = view.stage;
                            this.stage.execute((Runnable)this);
                            return;
                        }
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            view.downlinkDidFail(error);
                        }
                        throw error;
                    }
                    ++this.viewIndex;
                    continue;
                }
                if (this.phase >= this.phaseCount) break block6;
                this.endPhase(this.phase);
                this.viewIndex = 0;
                ++this.phase;
                this.preemptive = true;
                if (this.phase >= this.phaseCount) break;
                this.beginPhase(this.phase);
            }
            this.endPhase(this.phase);
            ++this.phase;
            this.done();
            return;
        }
    }

    @Override
    public void run() {
        try {
            if (this.viewCount == 1) {
                this.pass((DownlinkView)this.views);
            } else if (this.viewCount > 1) {
                this.pass((DownlinkView[])this.views);
            }
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                ((DownlinkModel)this.model).didFail(error);
            }
            throw error;
        }
    }
}

