/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.runtime.AndPartPredicate;
import swim.runtime.AnyPartPredicate;
import swim.runtime.HashPartPredicate;
import swim.runtime.NodePartPredicate;
import swim.runtime.PartPredicateForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriPattern;

public abstract class PartPredicate {
    private static Form<PartPredicate> form;
    private static PartPredicate any;

    protected PartPredicate() {
    }

    public abstract boolean test(Uri var1, int var2);

    public boolean test(Uri nodeUri) {
        return this.test(nodeUri, nodeUri.hashCode());
    }

    public PartPredicate and(PartPredicate that) {
        return new AndPartPredicate(this, that);
    }

    public abstract Value toValue();

    @Kind
    public static Form<PartPredicate> form() {
        if (form == null) {
            form = new PartPredicateForm();
        }
        return form;
    }

    public static PartPredicate any() {
        if (any == null) {
            any = new AnyPartPredicate();
        }
        return any;
    }

    public static PartPredicate and(PartPredicate ... predicates) {
        return new AndPartPredicate(predicates);
    }

    public static PartPredicate node(UriPattern nodePattern) {
        return new NodePartPredicate(nodePattern);
    }

    public static PartPredicate node(String nodePattern) {
        return new NodePartPredicate(UriPattern.parse((String)nodePattern));
    }

    public static PartPredicate hash(int lowerBound, int upperBound) {
        return new HashPartPredicate(lowerBound, upperBound);
    }

    public static PartPredicate fromValue(Value value) {
        String tag = value.tag();
        if ("node".equals(tag)) {
            return NodePartPredicate.fromValue(value);
        }
        if ("hash".equals(tag)) {
            return HashPartPredicate.fromValue(value);
        }
        return null;
    }
}

