/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import swim.concurrent.Conts;
import swim.runtime.LaneBinding;
import swim.runtime.PushRequest;
import swim.runtime.agent.AgentNode;

final class AgentModelPushUp
implements Runnable {
    final AgentNode node;
    final PushRequest pushRequest;

    AgentModelPushUp(AgentNode node, PushRequest pushRequest) {
        this.node = node;
        this.pushRequest = pushRequest;
    }

    @Override
    public void run() {
        try {
            LaneBinding laneBinding = this.node.getLane(this.pushRequest.envelope().laneUri());
            if (laneBinding != null) {
                laneBinding.pushUp(this.pushRequest);
            } else {
                this.pushRequest.didDecline();
            }
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.node.didFail(error);
            }
            throw error;
        }
    }
}

