/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.AgentContext;
import swim.api.http.function.DecodeRequestHttp;
import swim.api.http.function.DidRequestHttp;
import swim.api.http.function.DidRespondHttp;
import swim.api.http.function.DoRespondHttp;
import swim.api.http.function.WillRequestHttp;
import swim.api.http.function.WillRespondHttp;
import swim.api.lane.DemandLane;
import swim.api.lane.Lane;
import swim.api.lane.function.DidCommand;
import swim.api.lane.function.DidEnter;
import swim.api.lane.function.DidLeave;
import swim.api.lane.function.DidUplink;
import swim.api.lane.function.OnCue;
import swim.api.lane.function.WillCommand;
import swim.api.lane.function.WillEnter;
import swim.api.lane.function.WillLeave;
import swim.api.lane.function.WillUplink;
import swim.api.uplink.Uplink;
import swim.concurrent.Conts;
import swim.runtime.lane.DemandLaneModel;
import swim.runtime.lane.LaneView;
import swim.structure.Form;
import swim.structure.Value;

public class DemandLaneView<V>
extends LaneView
implements DemandLane<V> {
    protected final AgentContext agentContext;
    protected Form<V> valueForm;
    protected DemandLaneModel laneBinding;
    protected volatile OnCue<V> onCue;

    public DemandLaneView(AgentContext agentContext, Form<V> valueForm, Object observers) {
        super(observers);
        this.agentContext = agentContext;
        this.valueForm = valueForm;
        this.onCue = this.onCue;
    }

    public DemandLaneView(AgentContext agentContext, Form<V> valueForm) {
        this(agentContext, valueForm, null);
    }

    @Override
    public AgentContext agentContext() {
        return this.agentContext;
    }

    @Override
    public DemandLaneModel getLaneBinding() {
        return this.laneBinding;
    }

    void setLaneBinding(DemandLaneModel laneBinding) {
        this.laneBinding = laneBinding;
    }

    @Override
    public DemandLaneModel createLaneBinding() {
        return new DemandLaneModel();
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> DemandLaneView<V2> valueForm(Form<V2> valueForm) {
        return new DemandLaneView<V2>(this.agentContext, valueForm, this.typesafeObservers(this.observers));
    }

    public <V2> DemandLaneView<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public void setValueForm(Form<V> valueForm) {
        this.valueForm = valueForm;
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    public final boolean isSigned() {
        return false;
    }

    public DemandLaneView<V> isSigned(boolean isSigned) {
        return this;
    }

    @Override
    public void close() {
        this.laneBinding.closeLaneView(this);
    }

    @Override
    public DemandLaneView<V> observe(Object observer) {
        return (DemandLaneView)super.observe(observer);
    }

    @Override
    public DemandLaneView<V> unobserve(Object observer) {
        return (DemandLaneView)super.unobserve(observer);
    }

    public DemandLaneView<V> onCue(OnCue<V> onCue) {
        return this.observe(onCue);
    }

    @Override
    public DemandLaneView<V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public DemandLaneView<V> didCommand(DidCommand didCommand) {
        return this.observe(didCommand);
    }

    @Override
    public DemandLaneView<V> willUplink(WillUplink willUplink) {
        return this.observe(willUplink);
    }

    @Override
    public DemandLaneView<V> didUplink(DidUplink didUplink) {
        return this.observe(didUplink);
    }

    @Override
    public DemandLaneView<V> willEnter(WillEnter willEnter) {
        return this.observe(willEnter);
    }

    @Override
    public DemandLaneView<V> didEnter(DidEnter didEnter) {
        return this.observe(didEnter);
    }

    @Override
    public DemandLaneView<V> willLeave(WillLeave willLeave) {
        return this.observe(willLeave);
    }

    @Override
    public DemandLaneView<V> didLeave(DidLeave didLeave) {
        return this.observe(didLeave);
    }

    @Override
    public DemandLaneView<V> decodeRequest(DecodeRequestHttp<Object> decodeRequest) {
        return this.observe(decodeRequest);
    }

    @Override
    public DemandLaneView<V> willRequest(WillRequestHttp<?> willRequest) {
        return this.observe(willRequest);
    }

    @Override
    public DemandLaneView<V> didRequest(DidRequestHttp<Object> didRequest) {
        return this.observe(didRequest);
    }

    @Override
    public DemandLaneView<V> doRespond(DoRespondHttp<Object> doRespond) {
        return this.observe(doRespond);
    }

    @Override
    public DemandLaneView<V> willRespond(WillRespondHttp<?> willRespond) {
        return this.observe(willRespond);
    }

    @Override
    public DemandLaneView<V> didRespond(DidRespondHttp<?> didRespond) {
        return this.observe(didRespond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V dispatchOnCue(Uplink uplink) {
        Lane lane = SwimContext.getLane();
        Link link = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            block14: {
                Object observers = this.observers;
                if (observers instanceof OnCue) {
                    Object object;
                    try {
                        Object value = ((OnCue)observers).onCue(uplink);
                        if (value == null) break block14;
                        object = value;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                            break block14;
                        }
                        throw error;
                    }
                    return (V)object;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        Object object;
                        if (!(observer instanceof OnCue)) continue;
                        try {
                            Object value = ((OnCue)observer).onCue(uplink);
                            if (value == null) continue;
                            object = value;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                                continue;
                            }
                            throw error;
                        }
                        return (V)object;
                    }
                }
            }
            V v = null;
            return v;
        }
        finally {
            SwimContext.setLink((Link)link);
            SwimContext.setLane((Lane)lane);
        }
    }

    Value nextDownCue(Uplink uplink) {
        V object = this.dispatchOnCue(uplink);
        if (object != null) {
            return this.valueForm.mold(object).toValue();
        }
        return null;
    }

    public void cue() {
        this.laneBinding.cueDown();
    }
}

