/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Link;
import swim.api.data.MapData;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.runtime.CellContext;
import swim.runtime.LaneContext;
import swim.runtime.LinkBinding;
import swim.runtime.lane.JoinValueLaneDownlink;
import swim.runtime.lane.JoinValueLaneModelEntryIterator;
import swim.runtime.lane.JoinValueLaneModelValueIterator;
import swim.runtime.lane.JoinValueLaneRelayClear;
import swim.runtime.lane.JoinValueLaneRelayDownlink;
import swim.runtime.lane.JoinValueLaneRelayRemove;
import swim.runtime.lane.JoinValueLaneRelayUpdate;
import swim.runtime.lane.JoinValueLaneUplink;
import swim.runtime.lane.JoinValueLaneView;
import swim.runtime.lane.LaneModel;
import swim.runtime.lane.LaneView;
import swim.runtime.lane.ValueLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;

public class JoinValueLaneModel
extends LaneModel<JoinValueLaneView<?, ?>, JoinValueLaneUplink> {
    protected int flags;
    protected MapData<Value, Value> data;
    protected volatile HashTrieMap<Value, JoinValueLaneDownlink<?>> downlinks;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;
    static final AtomicReferenceFieldUpdater<JoinValueLaneModel, HashTrieMap<Value, JoinValueLaneDownlink<?>>> DOWNLINKS = AtomicReferenceFieldUpdater.newUpdater(JoinValueLaneModel.class, HashTrieMap.class, "downlinks");

    JoinValueLaneModel(int flags) {
        this.flags = flags;
        this.downlinks = HashTrieMap.empty();
    }

    public JoinValueLaneModel() {
        this(0);
    }

    @Override
    protected JoinValueLaneUplink createUplink(LinkBinding link) {
        return new JoinValueLaneUplink(this, link);
    }

    @Override
    public void setLaneContext(LaneContext laneContext) {
        super.setLaneContext(laneContext);
        this.openStore();
    }

    protected void openStore() {
        this.data = this.laneContext.store().mapData(this.laneUri().toString()).isTransient(this.isTransient()).isResident(this.isResident());
        this.openDownlinks();
    }

    protected void openDownlinks() {
        for (Map.Entry entry : this.data) {
            Value key = (Value)entry.getKey();
            Value value = (Value)entry.getValue();
            Value header = value.header("downlink");
            Uri nodeUri = (Uri)header.get("node").coerce(Uri.form());
            Uri laneUri = (Uri)header.get("lane").coerce(Uri.form());
            float prio = header.get("prio").floatValue(0.0f);
            float rate = header.get("rate").floatValue(0.0f);
            Value body = header.get("body");
            new JoinValueLaneDownlink((CellContext)this.laneContext, this.stage(), this, key, this.laneContext.meshUri(), this.laneContext.hostUri(), nodeUri, laneUri, prio, rate, body, Form.forValue()).openDownlink();
        }
    }

    protected void downlink(Value key, JoinValueLaneDownlink<?> downlink) {
        Value value = (Value)this.data.get((Object)key);
        Record header = value.headers("downlink");
        if (!(header != null && ((Uri)header.get("node").coerce(Uri.form())).equals((Object)downlink.nodeUri()) && ((Uri)header.get("lane").coerce(Uri.form())).equals((Object)downlink.laneUri()) && header.get("prio").floatValue(0.0f) == downlink.prio() && header.get("rate").floatValue(0.0f) == downlink.rate() && header.get("body").equals((Object)downlink.body()))) {
            header = Record.of().slot("node", downlink.nodeUri().toString()).slot("lane", downlink.laneUri().toString());
            if (downlink.prio() != 0.0f) {
                header.slot("prio", downlink.prio());
            }
            if (downlink.rate() != 0.0f) {
                header.slot("rate", downlink.rate());
            }
            if (downlink.body().isDefined()) {
                header.slot("body", downlink.body());
            }
            value = "downlink".equals(value.tag()) ? value.updatedAttr("downlink", (Value)header) : Record.of().attr("downlink", (Value)header).concat((Item)value);
            this.data.put((Object)key, (Object)value);
        }
        new JoinValueLaneRelayDownlink(this, key, downlink).run();
    }

    protected void openDownlink(Value key, JoinValueLaneDownlink<?> downlink) {
        JoinValueLaneDownlink oldDownlink;
        HashTrieMap newDownlinks;
        HashTrieMap<Value, JoinValueLaneDownlink<?>> oldDownlinks;
        downlink.openDownlink();
        while ((oldDownlinks = this.downlinks) != (newDownlinks = oldDownlinks.updated((Object)key, downlink)) && !DOWNLINKS.compareAndSet(this, oldDownlinks, newDownlinks)) {
        }
        if (oldDownlinks != newDownlinks && (oldDownlink = (JoinValueLaneDownlink)oldDownlinks.get((Object)key)) != null) {
            try {
                oldDownlink.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void closeDownlinks() {
        HashTrieMap<Value, JoinValueLaneDownlink<?>> oldDownlinks;
        HashTrieMap newDownlinks = HashTrieMap.empty();
        while ((oldDownlinks = this.downlinks) != newDownlinks && !DOWNLINKS.compareAndSet(this, oldDownlinks, newDownlinks)) {
        }
        if (!oldDownlinks.isEmpty()) {
            for (JoinValueLaneDownlink downlink : oldDownlinks.values()) {
                try {
                    downlink.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void closeDownlinkKey(Value key) {
        HashTrieMap newDownlinks;
        HashTrieMap<Value, JoinValueLaneDownlink<?>> oldDownlinks;
        while ((oldDownlinks = this.downlinks) != (newDownlinks = oldDownlinks.removed((Object)key)) && !DOWNLINKS.compareAndSet(this, oldDownlinks, newDownlinks)) {
        }
        if (oldDownlinks != newDownlinks) {
            JoinValueLaneDownlink downlink = (JoinValueLaneDownlink)oldDownlinks.get((Object)key);
            try {
                downlink.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void didOpenLaneView(JoinValueLaneView<?, ?> view) {
        view.setLaneBinding(this);
    }

    @Override
    public void onCommand(CommandMessage message) {
        Value payload = message.body();
        String tag = payload.tag();
        if ("update".equals(tag)) {
            Value header = payload.header("update");
            Value key = header.get("key");
            Item head = ((Value)this.data.get((Object)key)).head();
            Value newValue = payload.body();
            new JoinValueLaneRelayUpdate(this, null, message, key, newValue).run();
        } else if ("remove".equals(tag)) {
            Value header = payload.header("remove");
            Value key = header.get("key");
            new JoinValueLaneRelayRemove(this, null, message, key).run();
        } else if ("clear".equals(tag)) {
            new JoinValueLaneRelayClear(this, null, message).run();
        }
    }

    protected void cueDownKey(Value key) {
        FingerTrieSeq uplinks;
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                ((JoinValueLaneUplink)uplinks.get(i)).cueDownKey(key);
            }
        } while (uplinks != this.uplinks);
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public JoinValueLaneModel isResident(boolean isResident) {
        if (this.data != null) {
            this.data.isResident(isResident);
        }
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetResident(isResident);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ValueLaneView)viewArray[i]).didSetResident(isResident);
            }
        }
        return this;
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public JoinValueLaneModel isTransient(boolean isTransient) {
        if (this.data != null) {
            this.data.isTransient(isTransient);
        }
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetTransient(isTransient);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ValueLaneView)viewArray[i]).didSetTransient(isTransient);
            }
        }
        return this;
    }

    public final boolean isSigned() {
        return (this.flags & 4) != 0;
    }

    public JoinValueLaneModel isSigned(boolean isSigned) {
        this.flags = isSigned ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        Object views = this.views;
        if (views instanceof JoinValueLaneView) {
            ((JoinValueLaneView)views).didSetSigned(isSigned);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((JoinValueLaneView)viewArray[i]).didSetSigned(isSigned);
            }
        }
        return this;
    }

    public Value get(Object key) {
        if (key != null) {
            Value value = (Value)this.data.get(key);
            if ("downlink".equals(value.tag())) {
                value = value.body();
            }
            return value;
        }
        return Value.absent();
    }

    public JoinValueLaneDownlink<?> getDownlink(Object key) {
        return (JoinValueLaneDownlink)this.downlinks.get(key);
    }

    public void put(JoinValueLaneDownlink<?> downlink, Value key, Value newValue) {
        JoinValueLaneRelayUpdate relay = new JoinValueLaneRelayUpdate(this, (Link)downlink, key, newValue);
        relay.run();
    }

    public <K, V> V put(JoinValueLaneView<K, V> view, K keyObject, V newObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        Value newValue = valueForm.mold(newObject).toValue();
        JoinValueLaneRelayUpdate relay = new JoinValueLaneRelayUpdate(this, null, key, newValue);
        relay.keyForm = keyForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.stage = this.stage();
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }

    public <K, V> V remove(JoinValueLaneView<K, V> view, K keyObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        JoinValueLaneRelayRemove relay = new JoinValueLaneRelayRemove(this, null, key);
        relay.keyForm = keyForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.stage = this.stage();
        relay.run();
        if (relay.valueForm == valueForm) {
            return (V)relay.oldObject;
        }
        return null;
    }

    public void clear(JoinValueLaneView<?, ?> view) {
        JoinValueLaneRelayClear relay = new JoinValueLaneRelayClear(this, null);
        relay.stage = this.stage();
        relay.run();
    }

    public Iterator<Map.Entry<Value, Value>> iterator() {
        return new JoinValueLaneModelEntryIterator((Iterator<Map.Entry<Value, Value>>)this.data.iterator());
    }

    public Iterator<Value> keyIterator() {
        return this.data.keyIterator();
    }

    public Iterator<Value> valueIterator() {
        return new JoinValueLaneModelValueIterator((Iterator<Value>)this.data.valueIterator());
    }

    public Set<Map.Entry<Value, Value>> entrySet() {
        return this.data.entrySet();
    }

    public Set<Value> keySet() {
        return this.data.keySet();
    }

    public Collection<Value> values() {
        return this.data.values();
    }

    @Override
    protected void willStart() {
        super.willStart();
        this.openDownlinks();
    }
}

