/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.runtime.lane.JoinValueLaneModel;
import swim.runtime.lane.JoinValueLaneView;
import swim.runtime.lane.LaneRelay;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class JoinValueLaneRelayRemove
extends LaneRelay<JoinValueLaneModel, JoinValueLaneView<?, ?>> {
    final Link link;
    final CommandMessage message;
    Form<Object> keyForm;
    Form<Object> valueForm;
    final Value key;
    Object keyObject;
    Value oldValue;
    Object oldObject;

    JoinValueLaneRelayRemove(JoinValueLaneModel model, Link link, CommandMessage message, Value key) {
        super(model, 4);
        this.link = link;
        this.message = message;
        this.key = key;
    }

    JoinValueLaneRelayRemove(JoinValueLaneModel model, Link link, Value key) {
        super(model, 1, 3);
        this.link = link;
        this.message = null;
        this.key = key;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            ((JoinValueLaneModel)this.model).closeDownlinkKey(this.key);
            this.oldValue = (Value)((JoinValueLaneModel)this.model).data.remove((Object)this.key);
            if (this.valueForm != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
        }
    }

    @Override
    boolean runPhase(JoinValueLaneView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneWillRemove(this.keyObject);
            }
            return view.dispatchWillRemove(this.link, this.keyObject, preemptive);
        }
        if (phase == 2) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidRemove(this.keyObject, this.oldObject);
            }
            return view.dispatchDidRemove(this.link, this.keyObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        if (this.oldValue.isDefined()) {
            ((JoinValueLaneModel)this.model).sendDown((Value)Record.create((int)1).attr("remove", (Value)Record.create((int)1).slot("key", this.key)));
        }
    }
}

