/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.runtime.lane.LaneRelay;
import swim.runtime.lane.ListLaneModel;
import swim.runtime.lane.ListLaneView;
import swim.runtime.uplink.ListOperation;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class ListLaneRelayMove
extends LaneRelay<ListLaneModel, ListLaneView<?>> {
    final Link link;
    final CommandMessage message;
    final int fromIndex;
    final int toIndex;
    final Object key;
    Form<Object> valueForm;
    Value value;
    Object object;

    ListLaneRelayMove(ListLaneModel model, Link link, CommandMessage message, int fromIndex, int toIndex, Object key) {
        super(model, 4);
        this.link = link;
        this.message = message;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.key = key;
    }

    ListLaneRelayMove(ListLaneModel model, Link link, int fromIndex, int toIndex, Object key) {
        super(model, 1, 3);
        this.link = link;
        this.message = null;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.key = key;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            ((ListLaneModel)this.model).data.move(this.fromIndex, this.toIndex, this.key);
        }
    }

    @Override
    boolean runPhase(ListLaneView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.value = (Value)((ListLaneModel)this.model).data.get(this.fromIndex, this.key);
                this.object = valueForm.cast((Item)this.value);
                if (this.object == null) {
                    this.object = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneWillMove(this.fromIndex, this.toIndex, this.object);
            }
            return view.dispatchWillMove(this.link, this.fromIndex, this.toIndex, this.object, preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.laneDidMove(this.fromIndex, this.toIndex, this.object);
            }
            return view.dispatchDidMove(this.link, this.fromIndex, this.toIndex, this.object, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        Record header = Record.create((int)3).slot("key", Value.fromObject((Object)this.key)).slot("from", this.fromIndex).slot("to", this.toIndex);
        ((ListLaneModel)this.model).cueDownKey((Value)header, ListOperation.MOVE);
    }
}

