/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.runtime.lane.LaneRelay;
import swim.runtime.lane.ListLaneModel;
import swim.runtime.lane.ListLaneView;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class ListLaneRelayTake
extends LaneRelay<ListLaneModel, ListLaneView<?>> {
    final Link link;
    final CommandMessage message;
    final int upper;

    ListLaneRelayTake(ListLaneModel model, Link link, CommandMessage message, int upper) {
        super(model, 4);
        this.link = link;
        this.message = message;
        this.upper = upper;
    }

    ListLaneRelayTake(ListLaneModel model, Link link, int upper) {
        super(model, 1, 3);
        this.link = link;
        this.message = null;
        this.upper = upper;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            ((ListLaneModel)this.model).data.take(this.upper);
        }
    }

    @Override
    boolean runPhase(ListLaneView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                view.laneWillTake(this.upper);
            }
            return view.dispatchWillTake(this.link, this.upper, preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.laneDidTake(this.upper);
            }
            return view.dispatchDidTake(this.link, this.upper, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        ((ListLaneModel)this.model).sendDown((Value)Record.create((int)1).attr("take", this.upper));
    }
}

