/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECPrivateKeySpec;
import swim.security.EcDomainDef;
import swim.security.EcKeyDef;
import swim.security.EcPrivateKeyForm;
import swim.security.PrivateKeyDef;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class EcPrivateKeyDef
extends PrivateKeyDef
implements EcKeyDef {
    protected final EcDomainDef domain;
    protected final BigInteger secret;
    protected ECPrivateKey privateKey;
    private static int hashSeed;
    private static Form<EcPrivateKeyDef> form;

    EcPrivateKeyDef(EcDomainDef domain, BigInteger secret, ECPrivateKey privateKey) {
        this.domain = domain;
        this.secret = secret;
        this.privateKey = privateKey;
    }

    public EcPrivateKeyDef(EcDomainDef domain, BigInteger secret) {
        this(domain, secret, null);
    }

    @Override
    public final EcDomainDef domain() {
        return this.domain;
    }

    public final BigInteger secret() {
        return this.secret;
    }

    @Override
    public ECPrivateKey privateKey() {
        ECPrivateKey privateKey = this.privateKey;
        if (privateKey == null) {
            try {
                ECPrivateKeySpec keySpec = new ECPrivateKeySpec(this.secret, this.domain.toECParameterSpec());
                KeyFactory keyFactory = KeyFactory.getInstance("EC");
                this.privateKey = privateKey = (ECPrivateKey)keyFactory.generatePrivate(keySpec);
            }
            catch (GeneralSecurityException cause) {
                throw new RuntimeException(cause);
            }
        }
        return privateKey;
    }

    @Override
    public Key key() {
        return this.privateKey();
    }

    @Override
    public Value toValue() {
        return EcPrivateKeyDef.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof EcPrivateKeyDef) {
            EcPrivateKeyDef that = (EcPrivateKeyDef)other;
            return this.domain.equals(that.domain) && this.secret.equals(that.secret);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(EcPrivateKeyDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.domain.hashCode()), (int)this.secret.hashCode()));
    }

    public static EcPrivateKeyDef from(ECPrivateKey key) {
        return new EcPrivateKeyDef(EcDomainDef.from(key.getParams()), key.getS(), key);
    }

    @Kind
    public static Form<EcPrivateKeyDef> form() {
        if (form == null) {
            form = new EcPrivateKeyForm();
        }
        return form;
    }
}

