/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import swim.security.KeyForm;
import swim.security.PrivateKeyDef;
import swim.security.PublicKeyDef;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;

public abstract class KeyDef {
    private static Form<KeyDef> keyForm;

    public abstract Key key();

    public abstract Value toValue();

    public static KeyDef from(Key key) {
        if (key instanceof PublicKey) {
            return PublicKeyDef.from((PublicKey)key);
        }
        if (key instanceof PrivateKey) {
            return PrivateKeyDef.from((PrivateKey)key);
        }
        throw new IllegalArgumentException(key.toString());
    }

    @Kind
    public static Form<KeyDef> keyForm() {
        if (keyForm == null) {
            keyForm = new KeyForm();
        }
        return keyForm;
    }
}

