/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAKey;
import swim.codec.Output;
import swim.recon.Recon;
import swim.structure.Attr;
import swim.structure.Data;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;

public class ReconSignature {
    protected final Value payload;
    protected final Value protectedHeader;
    protected final Value signatureHeader;

    public ReconSignature(Value payload, Value protectedHeader, Value signatureHeader) {
        this.payload = payload;
        this.protectedHeader = protectedHeader;
        this.signatureHeader = signatureHeader;
    }

    public final Value payload() {
        return this.payload;
    }

    public final Value protectedHeader() {
        return this.protectedHeader;
    }

    public final Value signatureHeader() {
        return this.signatureHeader;
    }

    public Data hash() {
        Value hash = this.signatureHeader.get("hash");
        if (hash instanceof Data) {
            return (Data)hash;
        }
        return null;
    }

    protected Data signingInput() {
        Output output = Data.output();
        Recon.structureWriter().writeValue((Object)this.payload, output);
        Recon.structureWriter().writeAttr((Object)Text.from((String)"protected"), (Object)this.protectedHeader, output);
        return (Data)output.bind();
    }

    public boolean verifySignature(PublicKey publicKey) {
        String algorithm = ReconSignature.algorithm(publicKey);
        try {
            return this.verifyRsaSignature(Signature.getInstance(algorithm), publicKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    public boolean verifyRsaSignature(Signature signature, PublicKey publicKey) {
        try {
            signature.initVerify(publicKey);
            signature.update(this.signingInput().asByteBuffer());
            Data signatureData = this.hash();
            return signature.verify(signatureData.asByteArray(), 0, signatureData.size());
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public Value toValue() {
        Value value = this.payload;
        if (this.protectedHeader.isDefined()) {
            value = value.concat((Item)Attr.of((String)"protected", (Value)this.protectedHeader));
        }
        value = value.concat((Item)Attr.of((String)"signature", (Value)this.signatureHeader));
        return value;
    }

    public static ReconSignature from(Value value) {
        Record payload;
        Item signatureHeader;
        if (value instanceof Record && "signature".equals((signatureHeader = (payload = (Record)value).get(payload.length() - 1)).key().stringValue())) {
            payload.remove(payload.length() - 1);
            Item protectedHeader = payload.get(payload.length() - 1);
            if ("protected".equals(protectedHeader.key().stringValue())) {
                payload.remove(payload.length() - 1);
            } else {
                protectedHeader = Value.absent();
            }
            return new ReconSignature((Value)payload, protectedHeader.toValue(), signatureHeader.toValue());
        }
        return null;
    }

    public static ReconSignature parse(String recon) {
        return ReconSignature.from(Recon.parse((String)recon));
    }

    public static ReconSignature signRsa(Signature signature, PrivateKey privateKey, Value payload, Value protectedHeader, Value unprotectedHeader) {
        Output output = Data.output();
        Recon.structureWriter().writeValue((Object)payload, output);
        Recon.structureWriter().writeAttr((Object)Text.from((String)"protected"), (Object)protectedHeader, output);
        Data signingInput = (Data)output.bind();
        try {
            signature.initSign(privateKey);
            signature.update(signingInput.asByteBuffer());
            Data hash = Data.wrap((byte[])signature.sign());
            Record signatureHeader = unprotectedHeader.isDefined() ? unprotectedHeader.concat((Item)Slot.of((String)"hash", (Value)hash)) : Record.of((Object)Slot.of((String)"hash", (Value)hash));
            return new ReconSignature(payload, protectedHeader, (Value)signatureHeader);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static ReconSignature signRsa(PrivateKey privateKey, Value payload, Value protectedHeader, Value unprotectedHeader) {
        String algorithm = ReconSignature.algorithm(privateKey);
        try {
            Signature signature = Signature.getInstance(algorithm);
            return ReconSignature.signRsa(signature, privateKey, payload, protectedHeader, unprotectedHeader);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public static ReconSignature sign(PrivateKey privateKey, Value payload, Value protectedHeader, Value unprotectedHeader) {
        if (privateKey instanceof RSAKey) {
            return ReconSignature.signRsa(privateKey, payload, protectedHeader, unprotectedHeader);
        }
        throw new IllegalArgumentException("unsupported signing key type");
    }

    private static String rsaAlgorithm(RSAKey key) {
        return "SHA256withRSA";
    }

    private static String algorithm(Key key) {
        if (key instanceof RSAKey) {
            return ReconSignature.rsaAlgorithm((RSAKey)((Object)key));
        }
        return null;
    }
}

