/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.nio.ByteBuffer;
import swim.codec.Base64;
import swim.codec.Binary;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.security.JsonWebSignature;

final class JsonWebSignatureWriter
extends Writer<Object, JsonWebSignature> {
    final JsonWebSignature jws;
    final Writer<?, ?> part;
    final int step;

    JsonWebSignatureWriter(JsonWebSignature jws, Writer<?, ?> part, int step) {
        this.jws = jws;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, JsonWebSignature> pull(Output<?> output) {
        return JsonWebSignatureWriter.write(output, this.jws, this.part, this.step);
    }

    static Writer<Object, JsonWebSignature> write(Output<?> output, JsonWebSignature jws, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? Binary.writeByteBuffer((ByteBuffer)jws.signingInput.asByteBuffer(), output) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output.write(46);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? Base64.urlUnpadded().writeByteBuffer(jws.signatureData.asByteBuffer(), output) : part.pull(output)).isDone()) {
                return JsonWebSignatureWriter.done((Object)jws);
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return JsonWebSignatureWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return JsonWebSignatureWriter.error((Throwable)output.trap());
        }
        return new JsonWebSignatureWriter(jws, part, step);
    }

    static Writer<Object, JsonWebSignature> write(Output<?> output, JsonWebSignature jws) {
        return JsonWebSignatureWriter.write(output, jws, null, 1);
    }
}

