/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import swim.codec.Base64;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieSet;
import swim.json.Json;
import swim.security.KeyDef;
import swim.security.PrivateKeyDef;
import swim.security.PublicKeyDef;
import swim.structure.Item;
import swim.structure.Value;
import swim.util.Murmur3;

public class JsonWebKey
implements Debug {
    protected final Value value;
    private static int hashSeed;
    static ECParameterSpec p256;
    static ECParameterSpec p384;
    static ECParameterSpec p521;

    public JsonWebKey(Value value) {
        this.value = value.commit();
    }

    public Value get(String name) {
        return this.value.get(name);
    }

    public String keyType() {
        return this.value.get("kty").stringValue(null);
    }

    public String publicKeyUse() {
        return this.value.get("use").stringValue(null);
    }

    public HashTrieSet<String> keyOperations() {
        HashTrieSet keyOperations = HashTrieSet.empty();
        for (Item member : this.value.get("key_ops")) {
            String keyOperation = member.stringValue(null);
            if (keyOperation == null) continue;
            keyOperations = keyOperations.added((Object)keyOperation);
        }
        return keyOperations;
    }

    public String algorithm() {
        return this.value.get("alg").stringValue(null);
    }

    public String keyId() {
        return this.value.get("kid").stringValue(null);
    }

    public String x509Url() {
        return this.value.get("x5u").stringValue(null);
    }

    public FingerTrieSeq<String> x509CertificateChain() {
        FingerTrieSeq x509CertificateChain = FingerTrieSeq.empty();
        for (Item member : this.value.get("x5c")) {
            String x509Certificate = member.stringValue(null);
            if (x509Certificate == null) continue;
            x509CertificateChain = x509CertificateChain.appended((Object)x509Certificate);
        }
        return x509CertificateChain;
    }

    public String x509Sha1Thumbprint() {
        return this.value.get("x5t").stringValue(null);
    }

    public String x509Sha256Thumbprint() {
        return this.value.get("x5t#S256").stringValue(null);
    }

    public Key key() {
        String keyType = this.keyType();
        if ("EC".equals(keyType)) {
            return (Key)((Object)this.ecKey());
        }
        if ("RSA".equals(keyType)) {
            return (Key)((Object)this.rsaKey());
        }
        if ("oct".equals(keyType)) {
            return this.symmetricKey();
        }
        return null;
    }

    public KeyDef keyDef() {
        Key key = this.key();
        if (key != null) {
            return KeyDef.from(key);
        }
        return null;
    }

    public PublicKey publicKey() {
        String keyType = this.keyType();
        if ("EC".equals(keyType)) {
            return this.ecPublicKey();
        }
        if ("RSA".equals(keyType)) {
            return this.rsaPublicKey();
        }
        return null;
    }

    public PublicKeyDef publicKeyDef() {
        PublicKey publicKey = this.publicKey();
        if (publicKey != null) {
            return PublicKeyDef.from(publicKey);
        }
        return null;
    }

    public PrivateKey privateKey() {
        String keyType = this.keyType();
        if ("EC".equals(keyType)) {
            return this.ecPrivateKey();
        }
        if ("RSA".equals(keyType)) {
            return this.rsaPrivateKey();
        }
        return null;
    }

    public PrivateKeyDef privateKeyDef() {
        PrivateKey privateKey = this.privateKey();
        if (privateKey != null) {
            return PrivateKeyDef.from(privateKey);
        }
        return null;
    }

    public ECKey ecKey() {
        if (this.value.containsKey("d")) {
            return this.ecPrivateKey();
        }
        return this.ecPublicKey();
    }

    public ECPublicKey ecPublicKey() {
        ECParameterSpec params = JsonWebKey.ecParameterSpec(this.value.get("crv").stringValue());
        BigInteger x = JsonWebKey.parseBase64UrlUInt(this.value.get("x").stringValue());
        BigInteger y = JsonWebKey.parseBase64UrlUInt(this.value.get("y").stringValue());
        try {
            ECPublicKeySpec keySpec = new ECPublicKeySpec(new ECPoint(x, y), params);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return (ECPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public ECPrivateKey ecPrivateKey() {
        ECParameterSpec params = JsonWebKey.ecParameterSpec(this.value.get("crv").stringValue());
        BigInteger d = JsonWebKey.parseBase64UrlUInt(this.value.get("d").stringValue());
        try {
            ECPrivateKeySpec keySpec = new ECPrivateKeySpec(d, params);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return (ECPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public RSAKey rsaKey() {
        if (this.value.containsKey("d")) {
            return this.rsaPrivateKey();
        }
        return this.rsaPublicKey();
    }

    public RSAPublicKey rsaPublicKey() {
        BigInteger modulus = JsonWebKey.parseBase64UrlUInt(this.value.get("n").stringValue());
        BigInteger publicExponent = JsonWebKey.parseBase64UrlUInt(this.value.get("e").stringValue());
        try {
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, publicExponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public RSAPrivateKey rsaPrivateKey() {
        BigInteger modulus = JsonWebKey.parseBase64UrlUInt(this.value.get("n").stringValue());
        BigInteger privateExponent = JsonWebKey.parseBase64UrlUInt(this.value.get("d").stringValue());
        try {
            RSAPrivateKeySpec keySpec;
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            Value p = this.value.get("p");
            if (!p.isDefined()) {
                keySpec = new RSAPrivateKeySpec(modulus, privateExponent);
            } else {
                BigInteger publicExponent = JsonWebKey.parseBase64UrlUInt(this.value.get("e").stringValue());
                BigInteger primeP = JsonWebKey.parseBase64UrlUInt(p.stringValue());
                BigInteger primeQ = JsonWebKey.parseBase64UrlUInt(this.value.get("q").stringValue());
                BigInteger primeExponentP = JsonWebKey.parseBase64UrlUInt(this.value.get("dp").stringValue());
                BigInteger primeExponentQ = JsonWebKey.parseBase64UrlUInt(this.value.get("dq").stringValue());
                BigInteger crtCoefficient = JsonWebKey.parseBase64UrlUInt(this.value.get("qi").stringValue());
                Value oth = this.value.get("oth");
                if (!oth.isDefined()) {
                    keySpec = new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
                } else {
                    RSAOtherPrimeInfo[] otherPrimeInfo = new RSAOtherPrimeInfo[oth.length()];
                    for (int i = 0; i < otherPrimeInfo.length; ++i) {
                        Item item = oth.getItem(i);
                        BigInteger prime = JsonWebKey.parseBase64UrlUInt(oth.get("r").stringValue());
                        BigInteger primeExponent = JsonWebKey.parseBase64UrlUInt(oth.get("d").stringValue());
                        BigInteger coefficient = JsonWebKey.parseBase64UrlUInt(oth.get("t").stringValue());
                        otherPrimeInfo[i] = new RSAOtherPrimeInfo(prime, primeExponent, coefficient);
                    }
                    keySpec = new RSAMultiPrimePrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient, otherPrimeInfo);
                }
            }
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }

    public Key symmetricKey(String algorithm) {
        return new SecretKeySpec(JsonWebKey.parseBase64Url(this.value.get("k").stringValue()), algorithm);
    }

    public Key symmetricKey() {
        String algorithm = this.algorithm();
        if ("HS256".equals(algorithm)) {
            return this.symmetricKey("HmacSHA256");
        }
        if ("HS384".equals(algorithm)) {
            return this.symmetricKey("HmacSHA384");
        }
        if ("HS512".equals(algorithm)) {
            return this.symmetricKey("HmacSHA512");
        }
        return this.symmetricKey("");
    }

    public final Value toValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof JsonWebKey) {
            JsonWebKey that = (JsonWebKey)other;
            return this.value.equals((Object)that.value);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(JsonWebKey.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.value.hashCode()));
    }

    public void debug(Output<?> output) {
        output.write("JsonWebKey").write(46).write("from").write(40).debug((Object)this.value).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static JsonWebKey from(Value value) {
        return new JsonWebKey(value);
    }

    public static JsonWebKey parse(String jwk) {
        return JsonWebKey.from(Json.parse((String)jwk));
    }

    private static byte[] parseBase64Url(String value) {
        return (byte[])Base64.urlUnpadded().parseByteArray(Unicode.stringInput((String)value)).bind();
    }

    private static BigInteger parseBase64UrlUInt(String value) {
        return new BigInteger(1, JsonWebKey.parseBase64Url(value));
    }

    private static ECParameterSpec ecParameterSpec(String crv) {
        if ("P-256".equals(crv)) {
            if (p256 == null) {
                p256 = JsonWebKey.createECParameterSpec("secp256r1");
            }
            return p256;
        }
        if ("P-384".equals(crv)) {
            if (p384 == null) {
                p384 = JsonWebKey.createECParameterSpec("secp384r1");
            }
            return p384;
        }
        if ("P-521".equals(crv)) {
            if (p521 == null) {
                p521 = JsonWebKey.createECParameterSpec("secp521r1");
            }
            return p521;
        }
        return null;
    }

    private static ECParameterSpec createECParameterSpec(String stdName) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
            ECGenParameterSpec parameterSpec = new ECGenParameterSpec(stdName);
            keyPairGenerator.initialize(parameterSpec);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
            return publicKey.getParams();
        }
        catch (GeneralSecurityException cause) {
            throw new RuntimeException(cause);
        }
    }
}

