/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import swim.codec.Base64;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.collections.FingerTrieSeq;
import swim.json.Json;
import swim.security.JsonWebSignature;
import swim.security.JsonWebToken;
import swim.security.PublicKeyDef;
import swim.structure.Data;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Builder;

public class OpenIdToken
extends JsonWebToken {
    public OpenIdToken(Value value) {
        super(value);
    }

    public OpenIdToken() {
    }

    @Override
    public OpenIdToken issuer(String issuer) {
        return (OpenIdToken)super.issuer(issuer);
    }

    @Override
    public OpenIdToken subject(String subject) {
        return (OpenIdToken)super.subject(subject);
    }

    @Override
    public OpenIdToken audience(String audience) {
        return (OpenIdToken)super.audience(audience);
    }

    @Override
    public OpenIdToken audiences(String ... audiences) {
        return (OpenIdToken)super.audiences(audiences);
    }

    @Override
    public OpenIdToken expiration(long expiration) {
        return (OpenIdToken)super.expiration(expiration);
    }

    @Override
    public OpenIdToken notBefore(long notBefore) {
        return (OpenIdToken)super.notBefore(notBefore);
    }

    @Override
    public OpenIdToken issuedAt(long issuedAt) {
        return (OpenIdToken)super.issuedAt(issuedAt);
    }

    @Override
    public OpenIdToken jwtId(String jwtId) {
        return (OpenIdToken)super.jwtId(jwtId);
    }

    public long authTime() {
        return this.value.get("auth_time").longValue(0L);
    }

    public OpenIdToken authTime(long authTime) {
        return this.copy((Value)this.value.updatedSlot("auth_time", authTime));
    }

    public String nonce() {
        return this.value.get("nonce").stringValue(null);
    }

    public OpenIdToken nonce(String nonce) {
        return this.copy((Value)this.value.updatedSlot("nonce", nonce));
    }

    public Data accessTokenHash() {
        String atHash = this.value.get("at_hash").stringValue(null);
        if (atHash != null) {
            Parser parser = Base64.urlUnpadded().parse(Unicode.stringInput((String)atHash), Data.output());
            if (parser.isDone()) {
                return (Data)parser.bind();
            }
            Throwable trap = parser.trap();
            if (trap instanceof RuntimeException) {
                throw (RuntimeException)trap;
            }
            throw new RuntimeException(trap);
        }
        return null;
    }

    public OpenIdToken accessTokenHash(Data accessTokenHash) {
        Output atHash = Unicode.stringOutput();
        Base64.urlUnpadded().writeByteBuffer(accessTokenHash.asByteBuffer(), atHash);
        return this.copy((Value)this.value.updatedSlot("at_hash", (String)atHash.bind()));
    }

    public String authenticationContextClass() {
        return this.value.get("acr").stringValue(null);
    }

    public OpenIdToken authenticationContextClass(String authenticationContextClass) {
        return this.copy((Value)this.value.updatedSlot("acr", authenticationContextClass));
    }

    public FingerTrieSeq<String> authenticationMethods() {
        Builder builder = FingerTrieSeq.builder();
        for (Item member : this.value.get("amr")) {
            String authenticationMethod = member.stringValue(null);
            if (authenticationMethod == null) continue;
            builder.add((Object)authenticationMethod);
        }
        return (FingerTrieSeq)builder.bind();
    }

    public OpenIdToken authenticationMethods(String ... authenticationMethods) {
        return this.copy((Value)this.value.updatedSlot("amr", (Value)Record.of((Object[])authenticationMethods)));
    }

    public String authorizedParty() {
        return this.value.get("azp").stringValue(null);
    }

    public OpenIdToken authorizedParty(String authorizedParty) {
        return this.copy((Value)this.value.updatedSlot("azp", authorizedParty));
    }

    @Override
    protected OpenIdToken copy(Value value) {
        return new OpenIdToken(value);
    }

    public static OpenIdToken from(Value value) {
        return new OpenIdToken(value);
    }

    public static OpenIdToken parse(String json) {
        return new OpenIdToken(Json.parse((String)json));
    }

    public static OpenIdToken verify(JsonWebSignature jws, Iterable<PublicKeyDef> publicKeyDefs) {
        Value payload = jws.payload();
        OpenIdToken idToken = new OpenIdToken(payload);
        for (PublicKeyDef publicKeyDef : publicKeyDefs) {
            if (!jws.verifySignature(publicKeyDef.publicKey())) continue;
            return idToken;
        }
        return null;
    }

    public static OpenIdToken verify(String compactJws, Iterable<PublicKeyDef> publicKeyDefs) {
        JsonWebSignature jws = JsonWebSignature.parse(compactJws);
        if (jws != null) {
            return OpenIdToken.verify(jws, publicKeyDefs);
        }
        return null;
    }
}

