/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import swim.collections.FingerTrieSeq;
import swim.security.RsaPrimeDef;
import swim.security.RsaPrivateKeyDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Builder;

final class RsaPrivateKeyForm
extends Form<RsaPrivateKeyDef> {
    RsaPrivateKeyForm() {
    }

    public String tag() {
        return "RSAPrivateKey";
    }

    public Class<?> type() {
        return RsaPrivateKeyDef.class;
    }

    public Item mold(RsaPrivateKeyDef keyDef) {
        FingerTrieSeq<RsaPrimeDef> primeDefs = keyDef.primeDefs;
        int n = primeDefs.size();
        Record record = Record.create((int)((keyDef.publicExponent != null ? 4 : 3) + n)).attr(this.tag()).slot("modulus", (Value)Num.from((BigInteger)keyDef.modulus));
        if (keyDef.publicExponent != null) {
            record.slot("publicExponent", (Value)Num.from((BigInteger)keyDef.publicExponent));
        }
        record.slot("privateExponent", (Value)Num.from((BigInteger)keyDef.privateExponent));
        for (int i = 0; i < n; ++i) {
            record.add((Item)((RsaPrimeDef)primeDefs.get(i)).toValue());
        }
        return record;
    }

    public RsaPrivateKeyDef cast(Item item) {
        Value value = item.toValue();
        if (value.getAttr(this.tag()).isDefined()) {
            BigInteger modulus = null;
            BigInteger publicExponent = null;
            BigInteger privateExponent = null;
            Builder primeDefs = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item member = value.getItem(i);
                String name = member.key().stringValue();
                if ("modulus".equals(name)) {
                    modulus = member.toValue().integerValue(null);
                    continue;
                }
                if ("publicExponent".equals(name)) {
                    publicExponent = member.toValue().integerValue(null);
                    continue;
                }
                if ("privateExponent".equals(name)) {
                    privateExponent = member.toValue().integerValue(null);
                    continue;
                }
                RsaPrimeDef primeDef = (RsaPrimeDef)RsaPrimeDef.form().cast((Item)member.toValue());
                if (primeDef == null) continue;
                if (primeDefs == null) {
                    primeDefs = FingerTrieSeq.builder();
                }
                primeDefs.add((Object)primeDef);
            }
            if (modulus != null && privateExponent != null) {
                return new RsaPrivateKeyDef(modulus, publicExponent, privateExponent, (FingerTrieSeq<RsaPrimeDef>)(primeDefs != null ? (FingerTrieSeq)primeDefs.bind() : FingerTrieSeq.empty()));
            }
        }
        return null;
    }
}

