/*
 * Decompiled with CFR 0.152.
 */
package swim.server;

import java.io.IOException;
import swim.api.service.ServiceDef;
import swim.api.service.ServiceFactory;
import swim.api.space.SpaceDef;
import swim.auth.AuthenticatorKernel;
import swim.fabric.FabricKernel;
import swim.java.JavaKernel;
import swim.kernel.BootKernel;
import swim.kernel.Kernel;
import swim.kernel.KernelException;
import swim.kernel.KernelLoader;
import swim.remote.RemoteKernel;
import swim.service.ServiceKernel;
import swim.service.web.WebServiceKernel;
import swim.store.mem.MemStoreKernel;
import swim.structure.Item;
import swim.structure.Value;

public final class ServerLoader {
    private ServerLoader() {
    }

    public static Kernel loadServer() {
        return ServerLoader.loadServer(KernelLoader.class.getClassLoader());
    }

    public static Kernel loadServer(ClassLoader classLoader) {
        try {
            Value kernelConfig = KernelLoader.loadConfig((ClassLoader)classLoader);
            if (kernelConfig == null) {
                kernelConfig = KernelLoader.loadConfigResource((ClassLoader)classLoader, (String)"server.recon");
            }
            if (kernelConfig == null) {
                kernelConfig = Value.absent();
            }
            Kernel kernel = ServerLoader.loadServerStack(classLoader, kernelConfig);
            ServerLoader.loadSpaces(kernel, kernelConfig, classLoader);
            ServerLoader.loadServices(kernel, kernelConfig, classLoader);
            return kernel;
        }
        catch (IOException cause) {
            throw new KernelException((Throwable)cause);
        }
    }

    public static Kernel loadServerStack() {
        return ServerLoader.loadServerStack(KernelLoader.class.getClassLoader());
    }

    public static Kernel loadServerStack(ClassLoader classLoader) {
        return ServerLoader.injectServerStack(classLoader, null);
    }

    public static Kernel loadServerStack(ClassLoader classLoader, Value kernelConfig) {
        Kernel kernel = KernelLoader.loadKernelStack((ClassLoader)classLoader, (Value)kernelConfig);
        kernel = ServerLoader.injectServerStack(classLoader, kernel);
        return kernel;
    }

    public static Kernel injectServerStack(ClassLoader classLoader, Kernel kernel) {
        if (kernel == null) {
            kernel = new BootKernel();
        } else if (kernel.unwrapKernel(BootKernel.class) == null) {
            kernel = kernel.injectKernel((Kernel)new BootKernel());
        }
        if (kernel.unwrapKernel(MemStoreKernel.class) == null) {
            kernel = kernel.injectKernel((Kernel)new MemStoreKernel());
        }
        if (kernel.unwrapKernel(RemoteKernel.class) == null) {
            kernel = kernel.injectKernel((Kernel)new RemoteKernel());
        }
        if (kernel.unwrapKernel(ServiceKernel.class) == null) {
            kernel = kernel.injectKernel((Kernel)new ServiceKernel());
        }
        if (kernel.unwrapKernel(WebServiceKernel.class) == null) {
            kernel = kernel.injectKernel((Kernel)new WebServiceKernel());
        }
        if (kernel.unwrapKernel(AuthenticatorKernel.class) == null) {
            kernel = kernel.injectKernel((Kernel)new AuthenticatorKernel());
        }
        if (kernel.unwrapKernel(FabricKernel.class) == null) {
            kernel = kernel.injectKernel((Kernel)new FabricKernel());
        }
        if (kernel.unwrapKernel(JavaKernel.class) == null) {
            kernel = kernel.injectKernel((Kernel)new JavaKernel());
        }
        return kernel;
    }

    public static void loadSpaces(Kernel kernel, Value kernelConfig, ClassLoader classLoader) {
        int n = kernelConfig.length();
        for (int i = 0; i < n; ++i) {
            Item item = kernelConfig.getItem(i);
            SpaceDef spaceDef = kernel.defineSpace(item);
            if (spaceDef == null) continue;
            kernel.openSpace(spaceDef);
        }
    }

    public static void loadServices(Kernel kernel, Value kernelConfig, ClassLoader classLoader) {
        int n = kernelConfig.length();
        for (int i = 0; i < n; ++i) {
            Item item = kernelConfig.getItem(i);
            ServiceDef serviceDef = kernel.defineService(item);
            if (serviceDef == null) continue;
            ServiceFactory serviceFactory = kernel.createServiceFactory(serviceDef, classLoader);
            kernel.openService(serviceDef.serviceName(), serviceFactory);
        }
    }
}

